<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Update\Schema;


use Doctrine\ORM\Tools\SchemaTool;
use MotoStore\Platform\Doctrine\Service\EntityManager;

abstract class AbstractSchema implements SchemaInterface
{
    /**
     * @var EntityManager
     */
    protected $entityManager;

    /**
     * @var SchemaTool
     */
    protected $schemaTool;


    /**
     * AbstractSchema constructor.
     * @param EntityManager $entityManager
     */
    public function __construct (EntityManager $entityManager)
    {
        $this->entityManager = $entityManager;
    }


    /**
     * @return EntityManager
     */
    public function getEntityManager ()
    {
        return $this->entityManager;
    }

    /**
     * @return SchemaTool
     */
    protected function getSchemaTool ()
    {
        if (!$this->schemaTool)
        {
            $this
                ->entityManager
                ->getConnection ()
                ->getDatabasePlatform ()
                ->registerDoctrineTypeMapping ('enum', 'string');

            $this->schemaTool = new SchemaTool ($this->entityManager);
        }
        return $this->schemaTool;
    }

    /**
     * Check if class has data
     *
     * @param $class
     * @return mixed
     */
    protected function classHasData ($class)
    {
        $r = $this
            ->entityManager
            ->createQueryBuilder ()
            ->select ('count(c.id)')
            ->from ($class, 'c')
            ->getQuery ()
            ->getSingleScalarResult ();

        return $r;
    }

    /**
     * @param $sql
     * @throws \Exception
     */
    public function sample ($sql)
    {
        $parser = new \Moto\Sql\Parser ();
        $parser
            ->setTablePrefix ($this->getEntityManager ()->getTablePrefix ());

        $queries = $parser
            ->parseFile ($sql);

        if (!empty ($queries))
        {
            $this->execute('set foreign_key_checks=0');
            $this->iterateQueryCollection ($queries);
            $this->execute('set foreign_key_checks=1');
        }
    }

    /**
     * Query Iterator
     * @param $query_collection
     */
    private function iterateQueryCollection ($query_collection)
    {
        foreach ($query_collection as $query)
        {
            if (!empty ($query ['sql']))
            {
                $this->execute ($query ['sql']);
            }
        }
    }

    /**
     * Execute SQL string throw DBAL
     * @param $sql
     * @throws \Doctrine\DBAL\DBALException
     */
    private function execute ($sql)
    {
        $s = $this
            ->getEntityManager ()
            ->getConnection ()
            ->prepare ($sql);

        $s->execute ();
    }
}