<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Update\Version;


use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;

class Update_1 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {

        $classes = array (
            $this->entityManager->getClassMetadata ('MotoStore\Customer\Entity\Customer'),

            $this->entityManager->getClassMetadata ('MotoStore\Localization\Entity\Country'),
            $this->entityManager->getClassMetadata ('MotoStore\Localization\Entity\State'),

            $this->entityManager->getClassMetadata ('MotoStore\Mailer\Entity\Template'),

            $this->entityManager->getClassMetadata ('MotoStore\Order\Entity\Order'),
            $this->entityManager->getClassMetadata ('MotoStore\Order\Entity\Comment'),
            $this->entityManager->getClassMetadata ('MotoStore\Order\Entity\Product'),
            $this->entityManager->getClassMetadata ('MotoStore\Order\Entity\Transaction'),


            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Product'),
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Product\Locale'),
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Brand'),
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Category'),
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Category\Locale'),
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Property'),
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Property\Relation'),
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Property\Value'),

            $this->entityManager->getClassMetadata ('MotoStore\Settings\Entity\Currency'),
            $this->entityManager->getClassMetadata ('MotoStore\Settings\Entity\Discount'),
            $this->entityManager->getClassMetadata ('MotoStore\Settings\Entity\Option'),

            $this->entityManager->getClassMetadata ('MotoStore\Settings\Entity\Tax\Rate'),
            $this->entityManager->getClassMetadata ('MotoStore\Settings\Entity\Tax\Region'),
            $this->entityManager->getClassMetadata ('MotoStore\Settings\Entity\Tax\TaxClass'),
            $this->entityManager->getClassMetadata ('MotoStore\Settings\Entity\Tax\Zone'),
        );

        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
    }

    /**
     * Import new Data
     *u
     * @return mixed
     */
    public function import ()
    {
        $this->sample (MOTOSTORE_ROOT_DIR . '/var/samples/dictionary.sql');
        $this->importOptions ();
    }

    /**
     * Import Options
     */
    protected function importOptions ()
    {
        if (!$this->classHasData ('MotoStore\Settings\Entity\Option'))
        {
            $options = include MOTOSTORE_ROOT_DIR . '/var/samples/options.php';

            foreach ($options as $option)
            {
                $option = new Option ($option ['module_name'], $option ['option_key'], $option ['option_value']);
                $this->entityManager->persist ($option);
            }

            $this->entityManager->flush ();
        }
    }
}