<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Update\Version;

use MotoStore\Update\Schema\AbstractSchema;

class Update_11 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {

        $classes = array (
            $this->entityManager->getClassMetadata ('MotoStore\Order\Entity\Product'),
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Product'),
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Option'),
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\OptionValue'),
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Variant'),
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Variant\VariantOption'),
        );

        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
    }

    /**
     * Import new Data
     *u
     * @return mixed
     */
    public function import ()
    {
        $this->sample (MOTOSTORE_ROOT_DIR . '/var/samples/sample_11.sql');
    }


}