<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;

class Update_121 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {

    }

    public function import ()
    {
        $this->updateTranslation();
        $this->sample (MOTOSTORE_ROOT_DIR . '/var/samples/sample_121.sql');
    }

    public function updateTranslation ()
    {
        /** @var Option $option */
        $option = $this->entityManager
            ->getRepository ('MotoStore\Settings\Entity\Option')
            ->findOneBy (array(
                'module_name' => 'storesettings_system',
                'option_key' => 'localization'
            ));

        if ($option)
        {

            $this->entityManager->refresh ($option);
            $localization = json_decode ($option->getOptionValue (), true);

            if (!isset ($localization ['SHOPPING_CART_COMMENT']))
            {
                $localization ['SHOPPING_CART_COMMENT'] = 'Comment';
            }

            $option->setOptionValue(json_encode ($localization));

            $this->entityManager->merge ($option);
            $this->entityManager->flush ();
        }
    }
}