<?php


namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;

class Update_130 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {
        $classes = array (

            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Product'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

        $classes = array (
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Category\Relation'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

        $classes = array (
            $this->entityManager->getClassMetadata ('MotoStore\Order\Entity\Order'),
            $this->entityManager->getClassMetadata ('MotoStore\Customer\Entity\Customer'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

    }

    public function import ()
    {
        $this->updateOptions();
    }
    public function updateOptions(){

        $newOptions =   array(
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_zip'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_city'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_state'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_country'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_company'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_address2'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_address'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_lastname'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_shipping_form')
        );

        foreach ($newOptions as $opt){
            $option = $this->entityManager
                ->getRepository ('MotoStore\Settings\Entity\Option')
                ->findOneBy (array(
                    'module_name' => $opt[0],
                    'option_key' => $opt[1]
                ));
            if (!$option){
                $option = new Option ($opt [0], $opt [1], 1);
                $this->entityManager->persist ($option);
            }

        }
            $this->entityManager->flush ();

    }
}