<?php


namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;

class Update_131 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {

        $classes = array (

            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Product'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

        $classes = array (
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Category'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

        $classes = array (
            $this->entityManager->getClassMetadata ('MotoStore\Customer\Entity\Customer'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
        $classes = array (
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Category\Relation'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
        $this->fixProductsBtob();

    }

    public function import ()
    {

    }
    public function fixProductsBtob ()
    {
        $prefix = $this->entityManager->getTablePrefix ();
        $t =  $prefix . 'store_product';
        $sql = sprintf ("UPDATE " .  $t  .  " SET " .  $t  .  ".btob = 0 WHERE " .  $t  .  ".btob is NULL", $t);

        $statement = $this->entityManager->getConnection()->prepare ($sql);
        $statement->execute ();

    }
}