<?php


namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;

class Update_136 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {

        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Order\Entity\Order'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

    }
    public function addTranslation ()
    {
        /** @var Option $option */
        $option = $this->entityManager
            ->getRepository ('MotoStore\Settings\Entity\Option')
            ->findOneBy (array(
                'module_name' => 'storesettings_system',
                'option_key' => 'localization'
            ));

        if ($option)
        {

            $this->entityManager->refresh ($option);
            $localization = json_decode ($option->getOptionValue (), true);

            if (!isset ($localization ['ORDER_STATUS_PENDING']))
            {
                $localization ['ORDER_STATUS_PENDING'] = 'Pending';
            }

            if (!isset ($localization ['ORDER_WAITING_PAYMENT']))
            {
                $localization ['ORDER_WAITING_PAYMENT'] = 'Awaiting Payment';
            }

            if (!isset ($localization ['ORDER_STATUS_PROCESSING']) )
            {
                $localization ['ORDER_STATUS_PROCESSING'] = 'Processing';
            }

            if (!isset ($localization ['ORDER_STATUS_SHIPPED']))
            {
                $localization ['ORDER_STATUS_SHIPPED'] = 'Shipped';
            }

            if (!isset ($localization ['ORDER_PAYMENT_ACCEPTED']))
            {
                $localization ['ORDER_PAYMENT_ACCEPTED'] = 'Approved';
            }
            if (!isset ($localization ['ORDER_STATUS_ON_HOLD']))
            {
                $localization ['ORDER_STATUS_ON_HOLD'] = 'On Hold';
            }
            if (!isset ($localization ['ORDER_STATUS_CANCELED']))
            {
                $localization ['ORDER_STATUS_CANCELED'] = 'Canceled';
            }
            if (!isset ($localization ['ORDER_STATUS_COMPLETE']))
            {
                $localization ['ORDER_STATUS_COMPLETE'] = 'Completed';
            }
            if (!isset ($localization ['ORDER_STATUS_AWAITING_FULFILLMENT']))
            {
                $localization ['ORDER_STATUS_AWAITING_FULFILLMENT'] = 'Awaiting Fulfilment';
            }
            if (!isset ($localization ['AUTH_INCORRECT_EMAIL_PASSWORD']))
            {
                $localization ['AUTH_INCORRECT_EMAIL_PASSWORD'] = 'Incorrect Email or Password';
            }
            if (!isset ($localization ['AUTH_ACCOUNT_NOT_EXISTS']))
            {
                $localization ['AUTH_ACCOUNT_NOT_EXISTS'] = 'Account  does not exist';
            }
            if (!isset ($localization ['ACCOUNT_NO_ORDERS']))
            {
                $localization ['ACCOUNT_NO_ORDERS'] = 'There are no orders in your account​';
            }
            $option->setOptionValue(json_encode ($localization));

            $this->entityManager->merge ($option);
            $this->entityManager->flush ();


        }

    }

    public function import ()
    {

        $this->addTranslation ();
    }
}