<?php


namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;
use Moto;

class Update_140 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {
        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Product\Entity\Property'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Settings\Entity\Discount'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Order\Entity\Order'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
    }


    public function addTranslation ()
    {

        $option = $this->entityManager
            ->getRepository ('MotoStore\Settings\Entity\Option')
            ->findOneBy (array(
                'module_name' => 'storesettings_system',
                'option_key' => 'localization'
            ));

        if ($option)
        {

            $this->entityManager->refresh ($option);
            $localization = json_decode ($option->getOptionValue (), true);

            if (!isset ($localization ['COMPARE_TITLE']))
            {
                $localization ['COMPARE_TITLE'] = 'Comparison List';
            }

            if (!isset ($localization ['COMPARE_ADD_TO_CART']))
            {
                $localization ['COMPARE_ADD_TO_CART'] = 'Add to cart';
            }

            if (!isset ($localization ['COMPARE_CAN_ADD_3_PRODUCTS']) )
            {
                $localization ['COMPARE_CAN_ADD_3_PRODUCTS'] = 'you can add only 3 products to comparison list';
            }

            if (!isset ($localization ['CART_CHECKBOX_TERMS_TEXT']) )
            {
                $localization ['CART_CHECKBOX_TERMS_TEXT'] = 'I accept the Terms of Service';
            }
            if (!isset ($localization ['PROPERTIES']) )
            {
                $localization ['PROPERTIES'] = 'Properties';
            }
            if (!isset ($localization ['CART_SHIPPING_DISCOUNT']) )
            {
                $localization ['CART_SHIPPING_DISCOUNT'] = 'Shipping Discount';
            }

            $option->setOptionValue(json_encode ($localization));

            $this->entityManager->merge ($option);
            $this->entityManager->flush ();


        }

    }
    public function import ()
    {
        $this->addTranslation ();
        $this->sample (MOTOSTORE_ROOT_DIR . '/var/samples/sample_140.sql');
    }
}