<?php


namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;
use Moto;

class Update_144 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {
        $classes = array (
            $this->entityManager->getClassMetadata ( 'MotoStore\Product\Entity\Product'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Product\Entity\Category'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Product\Entity\Category\Relation'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
        $classes = array (
            $this->entityManager->getClassMetadata ( 'MotoStore\Product\Entity\Product\Locale'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

        $classes = array (
            $this->entityManager->getClassMetadata ( 'MotoStore\Product\Entity\Category\Locale'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
        $classes = array (
            $this->entityManager->getClassMetadata ('MotoStore\Mailer\Entity\Template'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

    }


    public function addTranslation ()
    {


    }

    public function import ()
    {
        $this->addTranslation ();
        $this->updateOptions();
        $this->fixOrderStatus();
        $this->updatePluginConnection();
    }

    public function fixOrderStatus ()
    {
        $prefix = $this->entityManager->getTablePrefix ();
        $t =  $prefix . 'store_order';
        $sql = sprintf ("UPDATE " .  $t  .  " SET " .  $t  .  ".status = 2 WHERE " .  $t  .  ".status  = 0", $t);
        $statement = $this->entityManager->getConnection()->prepare ($sql);
        $statement->execute ();
    }


    public function updateOptions(){
        $settings = Moto\Website\SitemapService::getSettings();
        $updated_settings = $settings;
        if ($settings && $settings['content_preferences']){
            foreach ($settings['content_preferences'] as $key=>$setting){
                if ($setting['type'] == "store.product"){
                    $updated_settings['content_preferences'][$key]['label']= "STORE.CATEGORY.SITEMAP_TITLE";
                }
                if ($setting['type'] == "store.category"){
                    $updated_settings['content_preferences'][$key]['label']= "STORE.PRODUCT.SITEMAP_TITLE";
                }
            }
        }
        Moto\Website\SitemapService::saveSettings($updated_settings);
    }

    public function updatePluginConnection(){


        if (class_exists('Moto\System\PluginManager', false)&& Moto\System\PluginManager::isInstalled('moto-store-plugin')  && Moto\System\PluginManager::isActivated('moto-store-plugin')) {
            if (method_exists('Moto\System', 'removeInjector')) {
                Moto\System::removeInjector('@plugins/moto-store-plugin/plugin.php');
            }

            return;
        }
        try {
            if (class_exists('Moto\System\PluginManager', false) && method_exists('Moto\System\PluginManager', 'activate') && method_exists('Moto\System\PluginManager', 'bootPlugin')&& method_exists('Moto\System\PluginManager', 'install')) {
                if  (!Moto\System\PluginManager::isInstalled('moto-store-plugin')){
                    Moto\System\PluginManager::install('moto-store-plugin');
                }
                Moto\System\PluginManager::activate('moto-store-plugin');
                Moto\System\PluginManager::bootPlugin('moto-store-plugin');

                return;
            }
        } catch (\Exception $e) {

        }
    }
}