<?php


namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;
use Moto;

class Update_146 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {
        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Order\Entity\Order'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
        $classes = array (
            $this->entityManager->getClassMetadata ( 'MotoStore\Customer\Entity\Customer'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
        $classes = array (
            $this->entityManager->getClassMetadata ( 'MotoStore\Product\Entity\Product\Locale'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
    }


    public function addTranslation ()
    {

        $option = $this->entityManager
            ->getRepository ('MotoStore\Settings\Entity\Option')
            ->findOneBy (array(
                'module_name' => 'storesettings_system',
                'option_key' => 'localization'
            ));

        if ($option)
        {

            $this->entityManager->refresh ($option);
            $localization = json_decode ($option->getOptionValue (), true);

            if (!isset ($localization ['FORM_ERROR_INCORRECT_EMAIL']))
            {
                $localization ['FORM_ERROR_INCORRECT_EMAIL'] = 'Your email address is invalid';
            }

            if (!isset ($localization ['CHECKOUT_DELIVERY_DATE_TITLE']))
            {
                $localization ['CHECKOUT_DELIVERY_DATE_TITLE'] = 'Delivery Date';
            }

            $option->setOptionValue(json_encode ($localization));

            $this->entityManager->merge ($option);
            $this->entityManager->flush ();


        }

    }

    public function import ()
    {
        $this->addTranslation ();
        $this->sample (MOTOSTORE_ROOT_DIR . '/var/samples/sample_146.sql');
    }

}