<?php


namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;

class Update_152 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {


    }

    public function import ()
    {
        $this->updateOptions();
    }
    public function updateOptions(){

        $newOptions =   array(
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_zip_required'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_city_required'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_state_required'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_country_required'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_company_required'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_address2_required'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_address_required'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_lastname_required'),
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_email_required')
        );

        foreach ($newOptions as $opt){
            $option = $this->entityManager
                ->getRepository ('MotoStore\Settings\Entity\Option')
                ->findOneBy (array(
                    'module_name' => $opt[0],
                    'option_key' => $opt[1]
                ));
            if (!$option){
                if($opt[1] == 'show_state_required'){
                    $option = new Option ($opt [0], $opt [1], 0);
                } else {
                    $option = new Option ($opt [0], $opt [1], 1);
                }
                $this->entityManager->persist ($option);
            }

        }

        $this->entityManager->flush ();

        $optRepository = $this->entityManager
            ->getRepository ('MotoStore\Settings\Entity\Option');
        $catalog_mode_value = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'disable_prices_on_cart_and_checkout');

        if ($catalog_mode_value){
            $option = new Option (Option::OPTION_STORE_SETTINGS_PRODUCT, 'catalog_mode', 1);
            $this->entityManager->persist ($option);
        }
        $this->entityManager->flush ();


    }
}