<?php
/**
 * Please don't edit this file.
 * This file will be rewrite on update.
 * Thanks.
 */
defined('MOTO_ENGINE') or die;

if (!isset($config)) {
    $config = array();
}

$config['html5Mode'] = false;
$config['logging'] = array(
    'application' => array(
        'deprecated' => false,
        'level' => 'info',
    ),
    'php' => array(
        'level' => E_ALL ^ E_NOTICE ^ E_WARNING ^ E_STRICT ^ E_DEPRECATED,
    ),
);
$config['apiUrl'] = 'api.php';
$config['allowedExtList'] = array(
    'png', 'jpeg', 'jpg', 'gif', 'ico', 'svg',
    'mp4', 'avi', 'swf', 'mp3', 'webm', 'webp',
    'pdf', 'djv', 'djvu', 'doc', 'docx', 'gdoc', 'rtf', 'rtx', 'txt', 'xls', 'xlsx', 'ots', 'odt', 'xml', 'ppt', 'pptx', 'pps', 'log', 'csv',
    'zip', 'rar', '7z', 'tar', 'tgz', 'gz', 'gzip', 'bz2',
    'cdr'
);
$config['deniedExtList'] = array(
    'htaccess', 'php', 'php2', 'php3', 'php4', 'php5', 'php6', 'cfm', 'cfc', 'bat', 'exe', 'com', 'dll',
    'vbs', 'js', 'reg', 'asis', 'phtm', 'phtml', 'pwml', 'inc', 'pl', 'py', 'jsp', 'asp', 'aspx', 'ascx', 'shtml', 'sh', 'cgi',
    'cgi4', 'pcgi', 'pcgi5', 'cmd',
);

$config['path'] = array(
    'websiteSettings' => '@website/mt-includes/config/settings.php',
    'websiteContentDir' => '@website/mt-content',
    'systemIncludes' => '@website/mt-includes',
    'mainTemplates' => '@website/mt-includes/templates',
    'layoutTemplates' => '@website/mt-includes/templates/layouts',
    'lessTemplates' => '@website/mt-includes/templates/less',
    'emailTemplates' => '@website/mt-includes/templates/emails',
    'phpLibrary' => '@website/mt-includes/library',
    'library' => '@website/mt-includes/library',
    'systemAssets' => '@website/mt-includes/assets',
    'admin' => '@website/mt-admin',
    'cpBrand' => '@website/mt-admin/brand',
    'systemUpdate' => '@website/mt-admin/update',
    'adminTemplates' => '@website/mt-admin/views',
    'adminServerErrorFile' => '@adminTemplates/server_error.php',
    'adminApplication' => '@website/mt-admin/js',
    'adminStyles' => '@website/mt-admin/css',
    'adminImages' => '@website/mt-admin/images',
    'adminFonts' => '@website/mt-admin/fonts',
    'editorApplication' => '@website/mt-admin/js',
    'editorStyles' => '@website/mt-admin/css',
    'install' => '@website/mt-admin/install', //@deprecated
    'installationDir' => '@website/mt-admin/install',
    'updateTemp' => '@website/mt-content/temp/update',
    'temp' => '@website/mt-content/temp',
    'cacheDir' => '@temp/cache',
    'cacheWebsitePageDir' => '@cacheDir/website_page/',
    'tempUploads' => '@website/mt-content/temp/uploads',
    'marketplaceTempDir' => '@temp/marketplace',
    'systemLogDir' => '@website/mt-content/temp/logs',
    'phpErrorsLogFile' => '@systemLogDir/php_errors.log',
    'applicationLogFile' => '@systemLogDir/moto.log',
    'themes' => '@website/mt-content/themes',
    'userUploads' => '@website/mt-content/uploads',
    'customFontsDir' => '@website/mt-content/uploads/fonts',
    'websiteStorageDir' => '@websiteContentDir/storage/website',
    'widgetsStorageDir' => '@websiteStorageDir/widgets/',
    'productInformationFile' => '@websiteStorageDir/product_information.php',
    'pluginsStorageDir' => '@websiteContentDir/storage/plugins',
    'pluginsTempDir' => '@temp/plugins',
    'userStylesFile' => '@website/mt-content/assets/styles.css',
    'userAssets' => '@website/mt-content/assets',
    'userFontsFile' => '@website/mt-content/assets/fonts.css',
    'userLessDir' => '@website/mt-content/assets/less',
    'systemWebsiteStyleLessDir' => '@website/mt-includes/templates/less/website',
    //default value
    'currentTheme' => '@website/mt-content/themes',

    'websiteWidgets' => '@website/mt-includes/widgets',
    'websiteElements' => '@website/mt-includes/elements',
    'plugins' => '@website/mt-content/plugins',
    'systemFavicon' => '@website/mt-admin/images/favicon.ico',
    'themeBlocksDataFile' => '@currentTheme/data/blocks/blocks.json',
    'websiteBlocksDataFile' => '@websiteStorageDir/blocks/blocks.json',
    'webFontsListFile' => '@websiteStorageDir/web-fonts/data.json',
    'primarySitemapFile' => '@website/sitemap.xml',
    'seoRobotTxtFile' => '@website/robots.txt',
    'additionalSitemapsDir' => '@websiteContentDir/storage/sitemaps/',
    'websiteBackupDir' => '@websiteContentDir/backups/',
    'websiteBackupTempDir' => '@temp/backup/',
    'websiteBackupSourceDir' => '@website/mt-backup/',
);

$config['mail'] = array(
    //global enabled flag
    'enabled' => true,
    //global options
    'options' => array(
        'fromName' => 'Robot',
        'transport' => array(
            'class' => 'Sendmail', // Sendmail | Smtp | File
            'parameters' => null,
        )
    ),
//@templates settings
);

$config['mail']['forgotPassword'] = array(
    //required
    'template' => 'forgot_password.html',
    //required
    'subject' => 'Reset Password ' . date('Y-m-d H:i:s'),
);

$config['mail']['usersAddNew'] = array(
    //required
    'template' => 'users_add_new.html',
    //required
    'subject' => 'Welcome {{user.name}} ' . date('Y-m-d H:i:s'),
);

$config['database'] = array(
    'driver' => 'Pdo_Mysql',
    'database' => '',
    'username' => '',
    'password' => '',
    'hostname' => 'localhost',
    'charset' => 'utf8mb4',
    'prefix' => '',
    'profiler' => false,
    'driver_options' => [],
);

$config['messenger'] = array(
    'timeout' => 5000
);

$config['futureRequirements'] = [
    'php_version' => 70205
];

$config['serverRequirements'] = array(
    'php_version' => array(
        '702' => array(
            'min' => '7.2.05',
            'recommended' => '7.2.10',
        ),
        '703' => array(
            'min' => '7.3.02',
            'recommended' => '7.3.08',
        ),
        '704' => array(
            'min' => '7.4.0',
            'recommended' => '7.4.0',
        ),
        '800' => array(
            'min' => '8.0.0',
            'recommended' => '8.0.0',
        ),
    ),
    'php_upload_file_size' => '2M',
    'enough_disk_space' => '40M',
    'extensions' => array(
        'curl' => array(),
        'spl' => array(),
        'openssl' => array(),
        'gd' => array('level' => 'warning'),
        'pdo_mysql' => array(),
        'mbstring' => array(),
        'iconv' => array(),
        'tokenizer' => array(),
        'zip' => array(),
        //'fileinfo' => array(), temporary remove, need more testing
    ),
    'files' => array(
        'path.websiteSettings' => array('type' => 'file'),
        'path.userStylesFile' => array('type' => 'file'),
        'path.userFontsFile' => array('type' => 'file'),
        'path.userAssets' => array('type' => 'folder'),
        'path.userLessDir' => array('type' => 'folder'),
        'path.userUploads' => array('type' => 'folder'),
        'path.customFontsDir' => array('type' => 'folder'),
        'path.websiteStorageDir' => array('type' => 'folder'),
        'path.pluginsStorageDir' => array('type' => 'folder'),
        'path.widgetsStorageDir' => array('type' => 'folder'),
        'path.additionalSitemapsDir' => array('type' => 'folder'),
        'path.websiteBackupDir' => array('type' => 'folder'),
        'path.websiteBackupTempDir' => array('type' => 'folder'),
        'path.temp' => array('type' => 'folder'),
        'path.pluginsTempDir' => array('type' => 'folder'),
        'path.updateTemp' => array('type' => 'folder'),
        'path.tempUploads' => array('type' => 'folder'),
        'path.marketplaceTempDir' => array('type' => 'folder'),
        'path.cacheDir' => array('type' => 'folder'),
        'path.cacheWebsitePageDir' => array('type' => 'folder'),

        'path.mainTemplates' => array('type' => 'folder', 'validator' => 'file_readable'),
        'path.layoutTemplates' => array('type' => 'folder', 'validator' => 'file_readable'),
        'path.lessTemplates' => array('type' => 'folder', 'validator' => 'file_readable'),
        'path.emailTemplates' => array('type' => 'folder', 'validator' => 'file_readable'),
        'path.phpLibrary' => array('type' => 'folder', 'validator' => 'file_readable'),
        'path.systemAssets' => array('type' => 'folder', 'validator' => 'file_readable'),
        'path.adminTemplates' => array('type' => 'folder', 'validator' => 'file_readable'),
        'path.systemUpdate' => array('type' => 'folder'),
        'path.systemLogDir' => array('type' => 'folder'),
        'path.themes' => array('type' => 'folder', 'validator' => 'file_readable'),
        'path.websiteWidgets' => array('type' => 'folder', 'validator' => 'file_readable'),
        'path.websiteElements' => array('type' => 'folder', 'validator' => 'file_readable'),
    ),
    'functions' => array(
        'json_encode' => array(),
        'session_start' => array(),
        'session_name' => array(),
        'xml_parser_create' => array(),
        'iconv_mime_decode' => array(),
        'timezone_identifiers_list' => array('level' => 'warning'),
        'date_default_timezone_set' => array('level' => 'warning'),
    ),
    /*
    // sample for extra validator list
    'validators' => array(
        array(
            'type' => 'php_extension_loaded',
            'params' => array(
                'extension' => 'aaaaaaaa'
            )
        ),
    ),
    */
);

// brand value
$config['brand'] = array(
    'apiUrl' => 'http://accounts.motocms.com/api/brand/checkbrand/',
    'links' => [
        'tutorial_center' => 'https://help.cms-guide.com/tutorial/',
        'additional_services' => 'https://www.motocms.com/website-templates/services/',
    ],
    'options' => array(
        'support_feedback_recipient_email' => 'feedback@motocms.com',
    ),
    'features' => array(
        'cp_help_center' => true,
        'cp_additional_services_available_locales' => [
            'en_US',
            'ru_RU',
            'uk_UA',
            'de_DE',
            'pl_PL',
            'es_ES',
        ],
        'cp_tutorial_center' => true,
        'cp_tutorial_center_auto_open' => false,
        'cp_support_feedback' => true,
        'cp_theme_full_info' => true,
        'cp_plugin_full_info' => true,
    ),
    'media' => array(
        'favicon.ico' => array(
            'path' => '@adminImages/favicon.ico',
        ),
        'loader.gif' => array(
            'path' => '@adminImages/loader.svg',
        ),
        'logo_small.png' => array(
            'path' => '@adminImages/logo_small.svg',
        ),
        'logo_medium.png' => array(
            'path' => '@adminImages/logo_medium.svg',
        ),
        'logo_large.png' => array(
            'path' => '@adminImages/logo_large.svg',
        ),
    ),
    'translations' => array(
        'COMPANY' => array(
            'NAME' => 'Moto',
            'WEBSITE' => 'https://www.motocms.com/',
            'EMAIL' => '',
            'DESCRIPTION' => '',
        ),
        'CONTROL_PANEL' => array(
            'NAME' => 'MotoCMS',
        ),
        'LINK' => array(
            'ACTIVATION' => 'https://accounts.motocms.com/',
            'HELP_CENTER' => "https://support.cms-guide.com/hc/{{'CURRENT_LANGUAGE'|translate}}/categories/200224390-MotoCMS-3",
            'HELP_CENTER_REQUEST' => "https://support.cms-guide.com/hc/{{'CURRENT_LANGUAGE'|translate}}/requests/new",
            'HELP_ERROR_NETWORK' => 'https://support.cms-guide.com/entries/20683912-network-error-please-check-your-connection',
            'TERMS_OF_USE' => '#',
            'PRIVACY_POLICY' => '#',
            'LICENCE_AGREEMENT' => '#',
        ),
    )
);

// Configuration for render engine
$config['renderEngine'] = array(
    '__default' => array(
        'loader' => array(
            'type' => 'Twig_Loader_Filesystem',
            'options' => array()
        ),
        'environment' => array(
            'auto_reload' => true,
            'cache' => '@temp/twig/'
        ),
        'extensions' => array(
            'assetExtension' => array(
                'options' => array(
                    'antiCache' => true
                )
            ),
        ),
        'addPath' => array(
            'systemAssets' => 'systemAssets',
            'layoutTemplates' => 'layoutTemplates',
            'mainTemplates' => 'mainTemplates',
            'websiteWidgets' => 'websiteWidgets',
            'websiteElements' => 'websiteElements',
            'lessTemplates' => 'lessTemplates',
            'emailTemplates' => 'emailTemplates',
            'currentTheme' => 'currentTheme',
            'userAssets' => 'userAssets',
            'systemIncludes' => 'systemIncludes',
            'userUploads' => 'userUploads',
            'websiteStorageDir' => 'websiteStorageDir',
            'pluginsStorageDir' => 'pluginsStorageDir',
            'plugins' => 'plugins',
        ),
    ),
    '__main__' => array(
        'loader' => array(
            'options' => array('@mainTemplates')
        ),
    ),
    'less' => array(
        'extensions' => array(
            'StyleHelperExtension' => array(
                'options' => array(
                    'colorAsVariable' => true
                )
            ),
        ),
    ),
    'admin' => array(
        'loader' => array(
            'options' => array('@adminTemplates')
        ),
        'extensions' => array(
            'assetExtension' => array(
                'options' => array(
                    'baseUrl' => '../'
                )
            )
        ),
    ),
    'string' => array(
        'loader' => array(
            'type' => 'Twig_Loader_String'
        ),
        'environment' => array(
            'cache' => null
        ),
    ),
);

$config['cacheEngine'] = array(
    'disabled' => array(
        'enabled' => true,
        'adapter' => array(
            'name' => 'memory',
            'options' => array(
                'memory_limit' => '10%',
            ),
        ),
    ),
    'default' => array(
        'enabled' => false,
        'adapter' => array(
            'name' => 'filesystem',
            'options' => array(
                'ttl' => 3600,
                'cache_dir' => '@temp/cache/',
            ),
        ),
    ),
);

$config['autoloadFiles'] = array(
    '@phpLibrary/vendor/autoload.php',
);
$config['autoloaderOptions'] = array(
    'Zend\Loader\StandardAutoloader' => array(
        'namespaces' => array(
            'Zend' => '@library/Zend',
            'Moto\Update' => '@admin/update/library/Moto/Update',
            'Moto' => '@library/Moto',
        ),
        'prefixes' => array(
            'Twig' => '@library/Twig',
        )
    ),
    'Zend\Loader\ClassMapAutoloader' => array(),
    'Moto\System\Widgets\Autoloader' => array(
        'paths' => array(
            '@websiteWidgets'
        )
    ),
    'Moto\System\Plugins\Autoloader' => array(),
);

$config['providers'] = array(
    Moto\System\Auth\Access\AccessServiceProvider::class,
    Moto\System\Providers\AppServiceProvider::class,
    Moto\Application\Installation\InstallationProvider::class,
    Moto\Website\Providers\WebsiteApplicationProvider::class,
    Illuminate\Bus\BusServiceProvider::class,
    Illuminate\Filesystem\FilesystemServiceProvider::class,
    Illuminate\Queue\QueueServiceProvider::class,
    Moto\System\Providers\SettingsServiceProvider::class,
    Moto\System\Providers\StyleHelperProvider::class,
    Moto\ClickAction\ServiceProvider::class,
    Moto\System\Backup\BackupProvider::class,
    Moto\System\Cache\CacheServiceProvider::class,
    Moto\System\Task\TaskServiceProvider::class,
    Moto\System\ContentSection\ContentSectionServiceProvider::class,
);

$config['provider'] = array(
    'backup' => [
        'enabled' => true,
    ]
);

$config['systemRecommend'] = array(
    'memory_limit' => '256M'
);

$config['__features__'] = array(
    'engine_thumbnails_available' => extension_loaded('gd'),
);

$config['api'] = array(
    'settings' => array(
        // 0 - no limits
        'concurrentConnections' => 3,
        'url' => 'api.php',
    ),
);

$config['externalModules'] = array(
    'accounts' => array(
        'appId' => '687373f3f6f25a50d46d497c5e037f43',
        'baseUrl' => 'https://accounts.motocms.com/',
        'authUrl' => 'https://accounts.motocms.com/signin/jwt/authorize',
        'productInfoUrl' => 'https://accounts.motocms.com/install/product/',
        'productUpdater' => array(
            'url' => 'https://accounts.motocms.com/restapi/v1/updater/status/',
            'checkPlugins' => true,
        ),
    ),
    'marketplace' => array(
        'baseUrl' => 'https://www.motocms.com/website-templates/marketplace/',
        'origins' => ['https://accounts.motocms.com', 'https://www.motocms.com', 'https://motocms.com', 'https://marketplace.motocms.com'],
    ),
    'dashboard' => [
        'baseUrl' => 'https://www.motocms.com/embed/dashboard/',
    ],
    'webFonts' => array(
        'apiUrl' => 'http://fonts-service.moto3dev.cms-guide.com/api',
    ),
    'unsplashService' => array(
        'apiUrl' => 'https://unsplash.service.cms-guide.com/api/v1',
    ),
    'themeContent' => array(
        'apiUrl' => 'http://accounts.motocms.com/restapi/media-files/api/v1/theme-files/list',
    ),
);

$config['httpClient'] = [
    'settings' => [
        'maxredirects' => 5,
        'argseparator' => '&',
    ],
];
$config['controlPanelAnalytics'] = array(
    'system' => array(
        'provider' => 'GoogleTagManager',
        'options' => array(
            'uid' => 'GTM-MMQ5RHP',
            'dataVariable' => 'dataLayerCP',
        ),
    ),
);
$config['controlPanel'] = array(
    'defaultState' => 'app.dashboard',
);
