<?php
namespace Moto\Application\Auth; use Moto; use Moto\Json\Server; use Moto\Authentication; use Exception; final class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'auth'; final public static function isAuthenticated($returnUser = false) { return Moto\Authentication\Service::isAuthenticated($returnUser); } final public static function isAuth() { return static::isAuthenticated(true); } final public static function login($email = null, $password = null, $remember = false) { $user = null; try { $credentials = array(); if (!empty($email)) { $credentials = array( 'email' => $email, 'password' => $password, 'remember' => $remember ); } $user = Moto\Authentication\Service::login($credentials); } catch (Exception $e) { if ($e instanceof Moto\System\Exception) { if ($e->getMessage() == Moto\System\Exception::ERROR_ACCESS_DENIED_MESSAGE && $e->getCode() == Moto\System\Exception::ERROR_ACCESS_DENIED_CODE ) { $e = new Moto\System\Exception(Moto\System\Exception::ERROR_AUTHORIZATION_DATA_MESSAGE, Moto\System\Exception::ERROR_AUTHORIZATION_DATA_CODE, null, $e); } } else { $e = new Moto\System\Exception(Moto\System\Exception::ERROR_ACCESS_DENIED_MESSAGE, Moto\System\Exception::ERROR_ACCESS_DENIED_CODE, null, $e); } throw $e; } if ($user instanceof Moto\Database\Models\User) { return Moto\Util::arrayExcept($user->toArray(), array('password', 'salt')); } return $user; } final public static function logout() { return Moto\Authentication\Service::logout(); } final public static function forgotPassword($email) { $data = array( 'email' => $email ); $filter = new ForgotPasswordFilter(); $filter->setData($data); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $email = $filter->getValue('email'); $user = Moto\Database\Models\User::where('email', $email)->first(); if (!$user) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } if (!$user->enabled) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_ACCESS_DENIED_MESSAGE, Moto\System\Exception::ERROR_ACCESS_DENIED_CODE, array('email' => array('accountDisabled'))); } $token = static::_generateToken($user); $link = static::_generateLink($token); static::_sendForgotPasswordMail($email, $link); return true; } final protected static function _sendForgotPasswordMail($email, $link) { $locale = Moto\Website\Settings::get('language_code'); Moto\Application\Util\Mailer::sendMailByName('forgotPassword', $email, array('link' => $link), $locale); return true; } final protected static function _generateLink($token) { $websiteAddress = Moto\System::getAbsoluteUrl('@website/mt-admin/'); $isRewriteAllow = Moto\Config::get('html5Mode', false); $link = $websiteAddress . ($isRewriteAllow ? 'auth/reset/' : '#!/auth/reset/') . $token . '/'; return $link; } final protected static function _generateToken($user) { $expiration = time() + 60 * 60 * 24; $signature = Moto\Authentication\Security::generateCookieTokenSignature($user, $expiration, 'forgot'); $token = $user->id . '-' . $expiration . '-' . $signature; return $token; } final public static function resetPassword($token, $password, $confirm) { $data = array( 'token' => $token, 'password' => $password, 'confirm' => $confirm ); $filter = new ResetPasswordFilter(); $filter->setData($data); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $token = $filter->getValue('token'); $tokenInfo = Moto\Authentication\Security::parseToken($token); if (!$tokenInfo['isValid']) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, array('token' => ( $tokenInfo['isExpired'] ? 'expired' : 'notValid'))); } $user = Moto\Database\Models\User::find($tokenInfo['userId']); if (!$user) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, array('token' => 'notValid')); } if (!$user->enabled) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_ACCESS_DENIED_MESSAGE, Moto\System\Exception::ERROR_ACCESS_DENIED_CODE, array('email' => array('accountDisabled'))); } if (!Moto\Authentication\Security::checkTokenSignature($user, $tokenInfo, 'forgot')) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, array('token' => 'notValid')); } $user->setPassword($filter->getValue('password')); $result = $user->save(); return $result; } public static function loginToPageByPassword($password = null, $pageId = null) { $page = Moto\Application\Pages\Service::getById($pageId * 1); if (!$page) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } if (Moto\Website\PasswordProtection::isVerifiedAccessPasswordPage($page, $password)) { Moto\Website\PasswordProtection::sendAccessPasswordToken($password); } else { throw new Moto\System\Exception(Moto\System\Exception::ERROR_ACCESS_DENIED_MESSAGE, Moto\System\Exception::ERROR_ACCESS_DENIED_CODE); } return true; } }