<?php
namespace Moto\Application\Backup; use Moto; use Carbon\Carbon; class Service extends Moto\Service\AbstractStaticService { const EXPIRED__OLDER_THEN = 86400; protected static $_resourceName = 'backup'; protected static $_resourcePrivilegesMap = array( 'getList' => 'get', 'deleteItem' => 'set', 'storeTask' => 'set', 'executeTask' => 'set', 'deleteTask' => 'get', 'getTaskList' => 'get', 'getFailedTasks' => 'get', 'getExpiredTasks' => 'get', 'getTrashedTasks' => 'get', ); protected static function requireManager() { $manager = Moto\System\Backup\BackupManager::getInstance(); if (!$manager->isEnabled()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_FAILED_DEPENDENCY_MESSAGE, Moto\System\Exception::ERROR_FAILED_DEPENDENCY_CODE, [ 'dependency' => 'BackupManager', ]); } return $manager; } public static function getList() { $manager = static::requireManager(); return $manager->findLocalBackups()->toArray(); } public static function deleteItem($file) { $manager = static::requireManager(); if (is_string($file)) { $path = $file; } else { $path = trim((string) Moto\Util::getValue($file, 'path')); } $item = $manager->createFileByPath($path); if (!$item) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE, [ 'path' => $path, ]); } return $item->delete(); } public static function storeTask() { return static::requireManager()->createNewTask(static::getRequest()->getParam('type'))->toArray(); } public static function executeTask() { return static::requireManager()->executeTask(static::getRequest()->getParam('task'))->toArray(); } public static function deleteTask($task) { $response = []; $isArray = is_array($task); $uids = (array) $task; $manager = static::requireManager(); foreach ($uids as $uid) { $taskObject = $manager->reviveTask($uid); $response[$uid] = [ 'uid' => $uid, 'existed' => false, 'deleted' => true, ]; if (!$taskObject) { continue; } $response[$uid]['existed'] = true; $response[$uid]['deleted'] = $taskObject->delete(); } return ($isArray ? $response : Moto\Util::getValue($response, $task)); } public static function getTaskList() { return static::requireManager()->findTasks(); } public static function getFailedTasks() { $collection = static::requireManager()->findTasks(function ($item) { return $item->failed; }); return $collection; } protected static function convertOlderThen($olderThen = null) { $fromTime = null; if ($olderThen === null) { $olderThen = static::EXPIRED__OLDER_THEN; } if (is_int($olderThen)) { $fromTime = time() - $olderThen; } elseif (is_string($olderThen) && preg_match('/^[0-9]{4}-[0-9]{2}-[0-9]{2}( [0-9]{2}:[0-9]{2}:[0-9]{2})?$/', $olderThen, $match)) { $fromTime = strtotime($olderThen); } if (!$fromTime) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, [ 'olderThen' => ['invalidValue',], ]); } return Carbon::createFromTimestamp($fromTime); } public static function getExpiredTasks($olderThen = null) { $olderThen = static::convertOlderThen($olderThen); $collection = static::requireManager()->findTasks(function ($item) use ($olderThen) { $updatedAt = $item->updated_at; if (!$updatedAt) { return true; } return $updatedAt->lessThan($olderThen); }); return $collection; } public static function getTrashedTasks($olderThen = null) { $olderThen = static::convertOlderThen($olderThen); $collection = static::requireManager()->findTasks(function ($item) use ($olderThen) { if ($item->failed) { return true; } $updatedAt = $item->updated_at; if (!$updatedAt) { return true; } return $updatedAt->lessThan($olderThen); }); return $collection; } } 