<?php
 namespace Moto\Application\Blocks; use Moto; use JsonSerializable; use Illuminate\Contracts\Support\Jsonable; use Illuminate\Contracts\Support\Arrayable; class BlockItem implements JsonSerializable, Jsonable, Arrayable { const PREVIEW_IMAGE_WIDTH = 245; protected $_attributes = array( 'id' => null, 'name' => 'block', 'provider' => null, 'previewUrl' => null, 'category' => 'more', 'order' => 1, 'allowed' => true, 'options' => array(), 'created_at' => null, 'updated_at' => null, ); protected $_collection; protected $_template; protected $_content; protected $_modified = array(); public function __construct($data, $collection) { if (is_array($data)) { $this->fromArray($data); } $this->setCollection($collection); $this->_updateData(); } public function fromArray($data) { $data = (array) $data; foreach ($data as $name => $value) { $this->__set($name, $value); } return $this; } public function setCollection($collection) { $this->_collection = $collection; return $this; } protected function _updateData() { if (!$this->id) { $this->id = $this->_collection->generateItemId($this); } if (!$this->created_at) { $this->updated_at = time(); $this->created_at = $this->updated_at; } if (empty($this->previewUrl)) { $this->previewUrl = $this->_getBasePath() . '/' . $this->category . '/' . $this->id . '.jpg'; } if ($this->isEmptyOption('contentUrl') && !empty($this->_content)) { $this->setOption('contentUrl', $this->_getBasePath() . '/' . $this->category . '/' . $this->id . '.json'); } } protected function _getBasePath() { $path = $this->_collection->getOption('basePath'); if (empty($path)) { throw new Moto\Exception('Base path not defined'); } return $path; } public function isEmptyOption($name) { return (array_key_exists($name, $this->_attributes['options']) ? empty($this->_attributes['options'][$name]) : true); } public function setOption($name, $value) { $this->_attributes['options'][$name] = $value; return $this; } public function toArray() { return $this->_attributes; } public function __get($name) { $value = (array_key_exists($name, $this->_attributes) ? $this->_attributes[$name] : null); $method = 'get' . str_replace(' ', '', ucwords(str_replace('_', ' ', $name))) . 'Attribute'; if (method_exists($this, $method)) { return $this->{$method}($value); } return $value; } public function __set($name, $value) { $method = 'set' . str_replace(' ', '', ucwords(str_replace('_', ' ', $name))) . 'Attribute'; if (method_exists($this, $method)) { return $this->{$method}($value); } else { $this->_attributes[$name] = $value; } } public function __isset($name) { return array_key_exists($name, $this->_attributes); } public function setTemplateAttribute($value) { $value = trim($value); if ($this->_template !== $value) { $this->_modified['template'] = true; } $this->_template = $value; } public function getTemplateAttribute() { if (empty($this->_template)) { $templateUrl = $this->getOption('templateUrl'); if (!empty($templateUrl)) { $templateUrl = Moto\System::getAbsolutePath($templateUrl); $this->_template = file_get_contents($templateUrl); $this->_template = trim($this->_template); } } return $this->_template; } public function setContentAttribute($value) { if ($this->_content !== $value) { $this->_modified['content'] = true; } $this->_content = $value; } public function getContentAttribute() { if (empty($this->_content)) { $contentUrl = $this->getOption('contentUrl'); if (!empty($contentUrl)) { $contentUrl = Moto\System::getAbsolutePath($contentUrl); $this->_content = file_get_contents($contentUrl); $this->_content = trim($this->_content); } } return $this->_content; } public function getOption($name, $default = null) { return (array_key_exists($name, $this->_attributes['options']) ? $this->_attributes['options'][$name] : $default); } public function setOptionsAttribute($value) { if (!is_array($value)) { return false; } $contentUrl = Moto\Util::getFrom($value, 'contentUrl'); if (is_string($contentUrl)) { $value['contentUrl'] = $contentUrl; } else { $value['templateUrl'] = Moto\Util::getFrom($value, 'templateUrl'); } $this->_attributes['options'] = $value; } public function isDraft() { return (empty($this->id) || empty($this->previewUrl)); } public function delete() { $this->deleted_at = time(); } public function save() { if ($this->trashed()) { $previewUrl = $this->previewUrl; $previewUrl = Moto\System::getAbsolutePath($previewUrl); if (file_exists($previewUrl)) { unlink($previewUrl); } $templateUrl = $this->getOption('templateUrl'); if (is_string($templateUrl)) { $templateUrl = Moto\System::getAbsolutePath($templateUrl); if (file_exists($templateUrl)) { unlink($templateUrl); } } $contentUrl = $this->getOption('contentUrl'); if (is_string($contentUrl)) { $contentUrl = Moto\System::getAbsolutePath($contentUrl); if (file_exists($contentUrl)) { unlink($contentUrl); } } return; } if (!$this->isModified()) { return; } $this->_updateData(); $this->updated_at = time(); if ($this->isModified('content') && !empty($this->_content)) { $contentUrl = $this->getOption('contentUrl'); $contentUrl = Moto\System::getAbsolutePath($contentUrl); Moto\Util::filePutContents($contentUrl, $this->_content, LOCK_EX); Moto\Util::disableDirectoryWebIndexing(dirname($contentUrl)); $templateUrl = $this->getOption('templateUrl'); if (is_string($templateUrl)) { $templateUrl = Moto\System::getAbsolutePath($templateUrl); if (file_exists($templateUrl)) { unlink($templateUrl); } unset($this->_attributes['options']['templateUrl']); } } } public function trashed() { return (array_key_exists('deleted_at', $this->_attributes)); } public function isModified($name = null) { if (empty($name)) { return !!count($this->_modified); } else { return array_key_exists($name, $this->_modified); } } public function savePreviewImage($content) { $data = Moto\Util::parseBase64Data($content); if (!$data) { Moto\System\Log::debug('[' . __CLASS__ . '::' . __FUNCTION__ . '] : Cant parse preview base64 content'); return false; } $previewUrl = $this->previewUrl; $previewPath = Moto\System::getAbsolutePath($previewUrl); Moto\Util::filePutContents($previewPath, $data['content']); list($originalWidth, $originalHeight) = getimagesize($previewPath); $originalProportion = $originalHeight / $originalWidth; $resizedWidth = static::PREVIEW_IMAGE_WIDTH; $resizedHeight = (int) $resizedWidth * $originalProportion; $resizedImage = imagecreatetruecolor($resizedWidth, $resizedHeight); $originalImage = imagecreatefromjpeg($previewPath); imagecopyresampled($resizedImage, $originalImage, 0, 0, 0, 0, $resizedWidth, $resizedHeight, $originalWidth, $originalHeight); imagejpeg($resizedImage, $previewPath, 100); return true; } public function jsonSerialize() { return $this->toArray(); } public function toJson($options = 0) { return json_encode($this->jsonSerialize(), $options); } } 