<?php
 namespace Moto\Application\Blocks; use Illuminate; use Moto; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'blocks'; protected static $_resourcePrivilegesMap = array( 'getList' => 'get', 'saveBlock' => 'set', 'saveToTheme' => 'set', 'deleteBlock' => 'set', 'deleteFromTheme' => 'set', 'saveCategory' => 'set', 'deleteCategory' => 'set', 'savePreviewImage' => 'set', ); protected static $_collections = []; public static function getBlockCollection($provider) { if (array_key_exists($provider, static::$_collections)) { return static::$_collections[$provider]; } $collection = null; if ($provider === 'theme') { $themeInfo = Moto\Website\Theme::getInfo(); $collection = new BlockTemplateCollection([ 'provider' => $provider, 'blocksDataFile' => '@themeBlocksDataFile', 'basePath' => '@currentTheme/data/blocks/', 'idPrefix' => Moto\Util::getFrom($themeInfo, 'name'), ]); } elseif ($provider === 'website') { $collection = new BlockTemplateCollection([ 'provider' => $provider, 'blocksDataFile' => '@websiteBlocksDataFile', 'basePath' => '@websiteStorageDir/blocks/', 'idPrefix' => 'website', ]); } static::$_collections[$provider] = $collection; return $collection; } public static function getList() { $themeCollections = static::getBlockCollection('theme'); $websiteCollections = static::getBlockCollection('website'); return [ 'categories' => $themeCollections ->getCategories() ->merge($websiteCollections->getCategories()) ->unique('name') ->values(), 'items' => $websiteCollections->getItems()->merge($themeCollections->getItems())->values(), ]; } public static function saveBlock($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $isNew = empty($request['id']); if ($isNew) { $filter = new InputFilter\NewBlockTemplate(); } else { $filter = new InputFilter\SaveBlockTemplate(); } $filter->setData($request); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); $collection = static::getBlockCollection($values['provider']); if (!$collection) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } unset($values['provider']); if ($isNew) { $item = $collection->addItem($values); } else { $item = $collection->getItemById($values['id']); if (!$item) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $item->fromArray($values); } $collection->save(); if (!empty($values['previewContent'])) { $item->savePreviewImage($values['previewContent']); } return $item->toArray(); } public static function saveToTheme($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $request['provider'] = 'theme'; return static::saveBlock($request); } public static function deleteBlock($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\DeleteBlockTemplate(); $filter->setData($request); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); $collection = static::getBlockCollection($values['provider']); if (!$collection) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $item = $collection->getItemById($values['id']); if (!$item) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $item->delete(); $collection->save(); return true; } public static function saveBlockPreview($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\SavePreviewImage(); $filter->setData($request); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $collection = static::getBlockCollection($values['provider']); if (!$collection) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $item = $collection->getItemById($values['id']); if (!$item) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $item->savePreviewImage($values['content']); return $item->toArray(); } public static function deleteFromTheme($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $request['provider'] = 'theme'; return static::deleteBlock($request); } public static function saveCategory($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $isNew = empty($request['id']); if ($isNew) { $filter = new InputFilter\NewBlockCategory(); } else { $filter = new InputFilter\SaveBlockCategory(); } $filter->setData($request); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); $collection = static::getBlockCollection($values['provider']); if (!$collection) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } unset($values['provider']); if ($isNew) { $item = $collection->getCategoryByName($values['name']); if ($item) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, [ 'name' => ['recordFound'], ]); } $item = $collection->addCategory($values); } else { $item = $collection->getCategoryById($values['id']); if (!$item) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $item->fromArray($values); } $collection->save(); return $item->toArray(); } public static function deleteCategory($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\DeleteBlockCategory(); $filter->setData($request); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); $collection = static::getBlockCollection($values['provider']); if (!$collection) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $category = $collection->getCategoryById($values['id']); if (!$category) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $item = $collection->getItems()->firstWhere('category', '=', $category->name); if ($item) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, [ 'items' => ['hasItems'] ]); } $category->delete(); $collection->save(); return true; } } 