<?php
 namespace Moto\Application\Cache; use Moto; use Illuminate; class WebsitePageService extends Moto\Application\Cache\BackendService { const SETTING_NAMESPACE = 'website_page'; protected $_resourceName = 'cache'; protected $_resourcePrivilegesMap = array( 'getSettings' => 'get', 'setSettings' => 'set', 'enableCaching' => 'set', 'disableCaching' => 'set', 'clearCache' => 'set', 'getCachableIds' => 'get', 'createCachedVersion' => 'set', 'storeTask' => 'set', 'getState' => 'get', 'executeTask' => 'set', ); public function getDefaultSettings() { return [ 'enabled' => false, 'exclude' => [], 'ttl' => '1days', ]; } public function setSettings($request = null) { if (!$request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\WebPageSetSettingsRequest(); $filter->setData($request); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } return $this->updateSettings($filter->getValues(true)); } public function enableCaching() { return $this->updateSettings([ 'enabled' => true, ]); } public function disableCaching() { return $this->updateSettings([ 'enabled' => false, ]); } public function clearCache() { $cache = Moto\System::app('cache.website_page'); return $cache->flush(); } public function getCachableIds() { $cache = Moto\System::app('cache.website_page'); $pages = $cache->getCachableItems(['id', 'type']); $pages = $pages->pluck('id'); return $pages; } public function createCachedVersion($targets) { if (is_array($targets)) { $result = []; foreach ($targets as $id) { $result[$id] = $this->createCachedVersion($id); } return $result; } $page = Moto\Application\Pages\Service::getById((int) $targets); $cache = Moto\System::app('cache.website_page'); if (!$cache->isCacheable($page)) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_CONFLICT_MESSAGE, Moto\System\Exception::ERROR_CONFLICT_CODE, [ 'reason' => 'ITEM_IS_NOT_CACHEABLE', ]); } $contentPage = Moto\Website\ContentPage::wrap($page); $contentPage->getRenderedWebsiteContent(true); return true; } protected function getTaskManager() { return Moto\System::app('task.manager'); } public function storeTask() { $ids = $this->getCachableIds(); if (empty($ids)) { throw new Moto\Exception('Nothing for caching'); } $task = new Moto\System\Cache\Tasks\GenerateWebsitePages([ 'pages' => $ids, ]); $state = $this->getTaskManager()->addTask($task); return $state->toResponse(); } public function getState($queue) { $query = Moto\System\Task\Database\JobTaskState::query(); $query->where('queue', $queue); return $query->firstOrFail(); } public function executeTask($queue, $force = false) { $taskWorker = Moto\System::app()->make('task.worker'); $query = Moto\System\Task\Database\JobTaskState::query(); $query->where('queue', $queue); $state = $query->firstOrFail(); if (!$state->isJobInPool()) { throw new Moto\System\Exception('TASK.ERROR.JOB_NOT_EXISTS', Moto\System\Exception::ERROR_NOT_FOUND_CODE); } if ($state->isFinished()) { throw new Moto\System\Exception('TASK.ERROR.TASK_ALREADY_FINISHED', Moto\System\Exception::ERROR_CONFLICT_CODE, [ 'state' => $state->toResponse(), ]); } if (!$force && $state->isRunning()) { throw new Moto\System\Exception('TASK.ERROR.TASK_ALREADY_RUNNING', Moto\System\Exception::ERROR_CONFLICT_CODE, [ 'state' => $state->toResponse(), ]); } $exception = null; ob_start(); try { $state = $taskWorker->runTask($state); } catch (\Exception $exception) { } ob_get_clean(); if ($exception) { throw $exception; } return $state->toResponse(); } } 