<?php
namespace Moto\Application\Content\Model; use Moto\Application\Model\AbstractModel; use Zend\Db\Sql\Select; use Moto; class ContentBlock extends AbstractModel { protected $_tableName = 'content_blocks'; protected $_fields = array( 'id' => array(), 'name' => array(), 'type' => array( 'default' => 'body' ), 'is_system' => array( 'default' => 0 ), 'content' => array( 'default' => '' ), 'properties' => array( 'default' => '{}', 'ignore_if_null' => true, ), 'styles' => array( 'default' => '' ), 'modified' => array(), 'created' => array() ); public $is_system = 0; public $styles; public function __construct() { if (Moto\Features::isEnabled('content_as_object')) { $this->_fields['content_data'] = array( 'default' => '{}', 'type' => 'array', ); $this->_fields['content_version'] = array( 'default' => 1, 'type' => 'int', ); } parent::__construct(); $this->created = date('Y-m-d H:i:s'); $this->modified = $this->created; } protected function _updateDataBeforeSaving(array $data, $action) { if (empty($data['styles'])) { $data['styles'] = ''; } if (!is_string($data['styles'])) { $data['styles'] = json_encode($data['styles']); } if (null == $data['properties']) { $data['properties'] = '{}'; } if (!is_string($data['properties'])) { $data['properties'] = json_encode($data['properties']); } if (!Moto\Features::isEnabled('content_as_object')) { return $data; } if (array_key_exists('content', $data)) { if ($data['content'] === null) { $data['content'] = ''; } elseif (!is_string($data['content'])) { $data['content'] = Moto\Util::toJson($data['content'], '@content'); } } if (array_key_exists('content_data', $data)) { if ($data['content_data'] === null) { $data['content_data'] = '{}'; } else { $contentHelper = new Moto\Website\PageSectionContent(); $contentHelper->setRawContent($data['content_data']); $contentHelper->runSaving($action); $data['content_data'] = $contentHelper->toJson(); } $data['content_version'] = 2; } return $data; } public function toUpdate() { $this->modified = date('Y-m-d H:i:s'); $data = parent::toUpdate(); unset($data['is_system']); unset($data['type']); if ($this->isBody()) { unset($data['name']); } $data = $this->_updateDataBeforeSaving($data, 'update'); return $data; } public function toInsert() { $data = parent::toInsert(); $data['is_system'] = 0; $data = $this->_updateDataBeforeSaving($data, 'insert'); return $data; } public function isBody() { return $this->type == 'body'; } public function __clone() { $this->id = null; $this->is_system = 0; $this->created = date('Y-m-d H:i:s'); $this->modified = $this->created; if (empty($this->properties)) { $this->properties = '{}'; } } public function exchangeArray($data) { parent::exchangeArray($data); if (is_string($this->properties)) { $this->properties = json_decode($this->properties); } } public function duplicate() { $newItem = clone $this; $select = new Select(Moto\Config::get('database.prefix') . $this->_tableName); $select->columns(array('name')); $select->where->equalTo('name', null); $select->where->equalTo('type', $this->type); $duplicateFilter = new Moto\Filter\Duplicate(array( 'duplicator' => array( 'name' => 'db', 'options' => array( 'suffix' => ' ', 'select' => $select ) ) )); $newItem->name = $duplicateFilter->filter($this->name); return $newItem; } public function getContentVersion() { return (property_exists($this, 'content_version') ? $this->content_version : 1); } }