<?php
 namespace Moto\Application\Content; use Moto\Json\Request; use Moto\Json\Response; use Moto\Json\Server; use Moto; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'content'; protected static $_resourcePrivilegesMap = array( 'getContent' => 'get', 'getById' => 'get', 'getBody' => 'get', 'getDefaultContent' => 'get', ); public static function getContent($request = null) { if (null === $request) $request = static::getRequest()->getParams(); if (!($request instanceof Request\Collection)) $request = new Request\Collection($request); $table = new Table\ContentBlocks(); $contentBlocks = $table->getList($request); if (!$contentBlocks) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $result = new Response\Collection($contentBlocks); return $result; } public static function getById($id) { $id = (int) $id; $table = new Table\ContentBlocks(); $table->useResultAsModel(true); $contentBlock = $table->getById($id); if (!$contentBlock) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } return $contentBlock; } public static function getBody($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $table = new Table\ContentBlocks(); $table->useResultAsModel(true); $body = $table->getBody(); if (!$body) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } return $body; } public static function save($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } if (Moto\Util::arrayHas($request, 'content_data')) { return static::saveAsObject($request); } $isNew = empty($request['id']); if ($isNew) { $filter = new InputFilter\NewContentBlock(); } else { $filter = new InputFilter\SaveContentBlock(); } $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); $table = new Table\ContentBlocks(); $table->useResultAsModel(true); if ($isNew) { Moto\System::gate()->authorize('create', Model\ContentBlock::class); $block = new Model\ContentBlock(); } else { $block = $table->getById($values['id']); if (!$block) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } Moto\System::gate()->authorize('update', $block); } $block->setFromArray($values); $table->save($block); return $block; } public static function saveAsObject($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $isNew = empty($request['id']); if ($isNew) { $filter = new InputFilter\NewContentBlockAsObject(); } else { $filter = new InputFilter\SaveContentBlockAsObject(); } $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); $table = new Table\ContentBlocks(); $table->useResultAsModel(true); if ($isNew) { Moto\System::gate()->authorize('create', Model\ContentBlock::class); $block = new Model\ContentBlock(); } else { $block = $table->getById($values['id']); if (!$block) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } Moto\System::gate()->authorize('update', $block); } $block->setFromArray($values); $table->save($block); return $block->toArray(); } public static function getDefaultContent($type = 'body') { $table = new Table\ContentBlocks(); $table->useResultAsModel(true); if ($type == 'body') { $contentBlock = $table->getBody(); } else { $contentBlock = $table->getDefaultContentBlock($type); } if (!$contentBlock) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } return $contentBlock; } protected static function _saveBlock(array $request, $type = 'body') { $request['type'] = $type; $result = array(); $isBody = $type == 'body'; $isSave = isset($request['id']) || $isBody; if ($isBody) { $filter = new InputFilter\SaveBody(); } else if ($isSave) { $filter = new InputFilter\SaveContentBlock(); } else { $filter = new InputFilter\NewContentBlock(); } $filter->setData($request); if (!$filter->isValid()) { $result['error'] = static::_fault(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); return $result; } $values = $filter->getValues(); $table = new Table\ContentBlocks(); $table->useResultAsModel(true); $contentBlock = null; if ($isSave) { $contentBlock = $isBody ? $table->getBody() : $table->getById($values['id']); if (!$contentBlock) { $result['error'] = static::_fault(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); return $result; } $contentBlock->setFromArray($values); $table->update($contentBlock); } elseif (!$isBody) { $contentBlock = new Model\ContentBlock(); $contentBlock->setFromArray($values); $table->insert($contentBlock); } $result['result'] = $contentBlock; return $result; } public static function delete($id) { $table = new Table\ContentBlocks(); $table->useResultAsModel(true); $id = (int) $id; $contentBlock = $table->getCustomContenBlockById($id); if (!$contentBlock) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } Moto\System::gate()->authorize('delete', $contentBlock); return $table->deleteContentBlock($contentBlock); } protected static function _fault($fault = null, $code = 404, $data = null) { $error = new \Zend\Json\Server\Error($fault, $code, $data); $response = new \Zend\Json\Server\Response\Http(); $response->setError($error); return $response->getError()->toArray(); } public static function duplicate($id) { Moto\System::gate()->authorize('create', Model\ContentBlock::class); $id = (int) $id; $table = new Table\ContentBlocks(); $table->useResultAsModel(true); $contentBlock = $table->getById($id); if (!$contentBlock) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } Moto\System::gate()->authorize('duplicate', $contentBlock); $newContentBlock = $table->createDuplicate($contentBlock); return $newContentBlock; } public static function preRenderContent($id) { $id = (integer) $id; $table = new Table\ContentBlocks(); $table->useResultAsModel(true); $record = $table->getById($id); if (!$record) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $contentHelper = new Moto\Website\PageSectionContent($record); $record->content = $contentHelper->toTemplate(Moto\Features::isEnabled('dev_warm_up_on_template')); $table->update($record); return $record; } public static function warmUpContent($id) { $id = (integer) $id; $table = new Table\ContentBlocks(); $table->useResultAsModel(true); $record = $table->getById($id); if (!$record) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $contentHelper = new Moto\Website\PageSectionContent($record); $contentHelper->warmUpContent(); return true; } } 