<?php
 namespace Moto\Application\Content; use Illuminate; use Moto; class TaxonomyService extends Moto\Service\AbstractService { protected $_resourceName = 'content.taxonomy'; protected $_resourcePrivilegesMap = array( 'getList' => 'get', 'getById' => 'get', ); protected function _getModelClass() { return $this->_getOption('modelClass', Moto\Database\Models\ContentTaxonomy::class); } public function save($request = null) { $request = $this->getRequest(); $id = $request->getParam('id'); if (empty($id)) { return $this->store($request); } else { return $this->update($request); } } public function store($request) { $class = $this->_getModelClass(); $params = $request->getParams(); $filter = new Moto\Application\Content\InputFilter\TaxonomyStoreRequest([ 'model' => new $class(), ]); $filter->setData($params); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); $item = new $class(); $item->fill($values); $item->save(); return $item->toArray(); } public function update($request) { $class = $this->_getModelClass(); $params = $request->getParams(); $filter = new Moto\Application\Content\InputFilter\TaxonomyUpdateRequest([ 'model' => new $class(), ]); $filter->setData($params); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); $item = $class::find($values['id']); if (!$item) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } unset($values['type']); $item->fill($values); $item->save(); return $item->toArray(); } public function getList($request = null) { $class = $this->_getModelClass(); $request = $this->getRequest(); $hasRules = (array) $request->getParam('has'); $query = $class::query(); foreach ((array) $request->getParam('withCount') as $relation) { if (is_string($relation)) { $query->withCount($relation); } } foreach ($hasRules as $rule) { if (is_string($rule)) { $rule = [ 'relation' => $rule, ]; } $relation = Moto\Util::getValue($rule, 'relation'); if (empty($relation)) { continue; } $count = Moto\Util::getValue($rule, 'count', 1); $operator = Moto\Util::getValue($rule, 'operator', '>='); $where = Moto\Util::getValue($rule, 'where'); if ($where === '@published') { $query->whereHas($relation, function ($query) { $query->where('status', '=', Moto\Application\Pages\PageModel::STATUS_PUBLISH); }); } elseif ($where === '@publishedNow') { $query->whereHas($relation, function ($query) { $query->where('status', '=', Moto\Application\Pages\PageModel::STATUS_PUBLISH); $query->where('published', '<=', date('Y-m-d H:i:s', time())); }); } else { $query->has($relation, $operator, $count); } } $type = $request->getParam('type'); if (!empty($type)) { if (is_array($type)) { $query->whereIn('type', $type); } else { $query->where('type', '=', $type); } } $query->with(['assignedTargets', 'publishedTargets']); $items = $query->orderBy('name')->get([ 'id', 'name', 'slug', 'type', 'created_at', ]); $response = new Moto\Json\Response\Collection(); $response->meta->exchangeArray(array( 'total' => $items->count(), 'page' => 1, )); $response->records = $items->transform(function ($item) { return Moto\Util::arrayOnly($item->toArray(), [ 'id', 'name', 'slug', 'type', 'assigned_targets_count', 'published_targets_count', 'created_at', ]); }); return $response; } public function getById($id) { $class = $this->_getModelClass(); $id = (int) $id; $item = $class::find($id); if (!$item) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } return $item; } public function delete($id) { $class = $this->_getModelClass(); $id = (int) $id; $item = $class::find($id); if (!$item) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } return $item->delete(); } } 