<?php
 namespace Moto\Application\ContentSection\InputFilter; use Moto; class StoreTaxonomyDefinition extends Moto\InputFilter\AbstractInputFilter { public function requireProvider() { $provider = $this->getOption('provider'); if (empty($provider)) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE, array('section' => array('notExists'))); } return $provider; } public function init() { $provider = $this->requireProvider(); $this->add([ 'name' => 'name', 'required' => true, 'filters' => [ ['name' => 'StripTags'], ['name' => 'StringTrim'], ], 'validators' => [ [ 'name' => 'Regex', 'break_chain_on_failure' => true, 'options' => [ 'pattern' => '/^u[_\-][a-z0-9\-]{1,16}$/', ] ], [ 'name' => Moto\Validator\Callback::class, 'break_chain_on_failure' => true, 'options' => [ 'callback' => function ($value, $context) use ($provider) { $Validator = $context['$Validator']; if ($provider->getTaxonomyDefinition($context['name'])) { $Validator->addError('alreadyExists'); return false; } return true; } ], ], [ 'name' => Moto\System\ContentSection\Validator\CreateTaxonomyUniqueProperty::class, 'options' => [ 'property' => 'name', 'provider' => $provider, ], 'break_chain_on_failure' => true, ], ], 'break_on_failure' => false, ]); $this->add([ 'name' => 'nameInPlural', 'required' => true, 'filters' => [ ['name' => 'StripTags'], ['name' => 'StringTrim'], ], 'validators' => [ [ 'name' => 'Regex', 'break_chain_on_failure' => true, 'options' => [ 'pattern' => '/^u[_\-][a-z0-9\-]{1,16}$/', ] ], [ 'name' => Moto\System\ContentSection\Validator\CreateTaxonomyUniqueProperty::class, 'options' => [ 'property' => 'nameInPlural', 'provider' => $provider, ], 'break_chain_on_failure' => true, ], ], 'break_on_failure' => false, ]); $this->add([ 'name' => 'uri', 'required' => true, 'filters' => [ ['name' => 'StripTags'], ['name' => 'StringTrim'], ], 'validators' => [ [ 'name' => 'Regex', 'break_chain_on_failure' => true, 'options' => [ 'pattern' => '/^[a-z0-9\-\/]{1,32}$/', ] ], [ 'name' => Moto\System\ContentSection\Validator\CreateTaxonomyUniqueProperty::class, 'options' => [ 'property' => 'uri', 'provider' => $provider, ], 'break_chain_on_failure' => true, ], ], 'break_on_failure' => false, ]); $this->add([ 'name' => 'type', 'required' => false, 'filters' => [ [ 'name' => Moto\Filter\DefaultFilter::class, 'options' => [ 'value' => 'many' ] ], ], 'validators' => [ [ 'name' => 'InArray', 'options' => [ 'haystack' => ['many', 'one',] ], ], ], ]); $this->add(new TaxonomyDefinitionTexts([ 'provider' => $provider, ]), 'texts'); } } 