<?php
 namespace Moto\Application\ContentSection\InputFilter; use Moto; class UpdateTaxonomyDefinition extends Moto\InputFilter\AbstractInputFilter { public function requireProvider() { $provider = $this->getOption('provider'); if (empty($provider)) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE, array('section' => array('notExists'))); } return $provider; } public function init() { $provider = $this->requireProvider(); $this->add([ 'name' => 'name', 'required' => true, 'filters' => [ ['name' => 'StripTags'], ['name' => 'StringTrim'], ], 'validators' => [ [ 'name' => 'Regex', 'break_chain_on_failure' => true, 'options' => [ 'pattern' => '/^[a-z0-9\-_]{1,18}$/', ] ], [ 'name' => Moto\Validator\Callback::class, 'break_chain_on_failure' => true, 'options' => [ 'callback' => function ($value, $context) use ($provider) { $Validator = $context['$Validator']; if (!$provider->getTaxonomyDefinition($context['name'])) { $Validator->addError('notExists'); return false; } return true; } ], ], ], 'break_on_failure' => true, ]); $this->add([ 'name' => 'uri', 'required' => true, 'filters' => [ ['name' => 'StripTags'], ['name' => 'StringTrim'], ], 'validators' => [ [ 'name' => 'Regex', 'break_chain_on_failure' => true, 'options' => [ 'pattern' => '/^[a-z0-9\-\/]{1,32}$/', ] ], [ 'name' => Moto\Validator\Callback::class, 'break_chain_on_failure' => true, 'options' => [ 'callback' => function ($value, $context) use ($provider) { $Validator = $context['$Validator']; $definition = $provider->getTaxonomyDefinition($context['name']); if (!$definition) { return false; } if ($value === $definition['uri']) { return true; } $definitions = $provider->getTaxonomyDefinitions()->except('name', $context['name']); if ($definitions->firstWhere('uri', $value)) { $Validator->addError('notUnique'); return false; } return true; } ], ], ], 'break_on_failure' => false, ]); $this->add(new TaxonomyDefinitionTexts([ 'provider' => $provider, ]), 'texts'); } } 