<?php
namespace Moto\Application\FileManager; use Moto\Application\FileManager\Filter\GenerateUniqueName; use Moto\Json\Request; use Moto\Json\Server; use Moto\Json\Response; use Zend\Filter; use Zend\Validator; use Zend\Stdlib\ErrorHandler; use Moto; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'fileManager'; protected static $_resourcePrivilegesMap = array( 'scan' => 'get', 'getInfo' => 'get', ); public static function scan($path = '') { $filter = new Moto\Filter\RelativePath(); $path = $filter->filter($path); $pathToScan = Moto\System::getAbsolutePath('@userUploads/' . $path); if (!is_dir($pathToScan) || !is_readable($pathToScan)) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $items = array(); $isWindows = (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN'); foreach(scandir($pathToScan) as $item) { if ($item == '.' || $item == '..') { continue; } $filePath = $pathToScan . '/' . $item; if ($isWindows) { $item = mb_convert_encoding($item, 'UTF-8', 'Windows-1251'); } $data = array( 'name' => $item, 'size' => is_dir($filePath) ? 0 : filesize($filePath), 'type' => is_dir($filePath) ? 'folder' : 'file' ); $items[] = $data; } $result = new Response\Collection(array( 'records' => $items )); return $result; } public static function getInfo() { $data = array( 'upload_max_size' => min(PHP_INT_MAX, Moto\Util::convertSizeStringToInteger(min(ini_get('upload_max_filesize'), ini_get('post_max_size')))), 'disk_total_space' => (Moto\Util::isFunctionDisabled('disk_total_space') ? false : @disk_total_space('.')), 'disk_free_space' => (Moto\Util::isFunctionDisabled('disk_free_space') ? false : @disk_free_space('.')), 'allowed_ext_list' => static::getAllowedFileExtensions(), 'denied_ext_list' => Moto\Config::get('deniedExtList') ); return $data; } public static function getAllowedFileExtensions() { return Moto\Config::get('allowedExtList'); } public static function upload($request = null) { if (null === $request){ $request = static::getRequest()->getParams(); } $fileRequest = new \Zend\Http\PhpEnvironment\Request(); $inputFilter = new InputFilter\UploadFile(); $inputFilter->setData(array_merge($fileRequest->getFiles()->toArray(), $request)); if (!$inputFilter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $inputFilter->getMessagesKeys()); } $file = $inputFilter->getValue('file'); return $file; } public static function createFolder($request = null) { if (null === $request){ $request = static::getRequest()->getParams(); } $filter = new InputFilter\CreateFolder(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $path = $values['path']; $origPath = $path; $path = Moto\System::getAbsolutePath('@userUploads/' . $path); $dirname = dirname($path); if (!is_dir($dirname) || !is_writable($dirname)) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } ErrorHandler::start(); $result = mkdir($path); $warningException = ErrorHandler::stop(); if (!$result || null !== $warningException) { throw new Server\Exception(sprintf("An error occurred while creating the folder '%s'", $origPath), 500); } return $origPath; } public static function rename($request = null) { if (null === $request){ $request = static::getRequest()->getParams(); } $filter = new InputFilter\Rename(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $dirname = dirname($values['source']); ErrorHandler::start(); $result = rename($values['source'], $dirname . '/' . $values['target']); $warningException = ErrorHandler::stop(); if (!$result || null !== $warningException) { throw new Server\Exception(sprintf("An error occurred while renaming '%s' to '%s'", $request['source'], $request['target']), 500); } return $result; } public static function delete($request = null) { if (null === $request){ $request = static::getRequest()->getParams(); } $filter = new InputFilter\Delete(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); ErrorHandler::start(); $result = is_dir($values['path']) ? rmdir($values['path']) : unlink($values['path']); $warningException = ErrorHandler::stop(); if (!$result || null !== $warningException) { throw new Server\Exception(sprintf("An error occurred while deleting '%s'", $request['path']), 500); } return $result; } public static function duplicate($request = null) { if (null === $request){ $request = static::getRequest()->getParams(); } $filter = new InputFilter\Duplicate(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $sourceFile = $values['path']; $dirpath = dirname($values['path']); $duplicateFilter = new Moto\Filter\Duplicate(array( 'duplicator' => array( 'name' => 'file', 'options' => array( 'path' => $dirpath ) ) )); $targetFile = $dirpath . DIRECTORY_SEPARATOR . $duplicateFilter->filter(basename($values['path'])); ErrorHandler::start(); $result = copy($sourceFile, $targetFile); $warningException = ErrorHandler::stop(); if (!$result || null !== $warningException) { $message = sprintf("An error occurred while duplicating '%s'", $request['path']); if (Moto\Config::get('env') == 'development' && is_object($warningException)) { $message = sprintf("An error occurred while duplicating '%s'. Details - %s", $request['path'], $warningException->getMessage()); } throw new Server\Exception($message, 500); } return $result; } }