<?php
namespace Moto\Application\Fonts; use Moto\Json\Server; use Moto; use Zend; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'fonts'; protected static $_resourcePrivilegesMap = array( 'getActiveList' => 'get', 'delete' => 'set', 'save' => 'set', 'getById' => 'get', 'storeFont' => 'set', 'uploadFontVariant' => 'set', 'destroyFontVariant' => 'set', ); public static function getActiveList() { $query = Moto\Database\Models\Font::query(); $query->where('active', true); $items = $query->orderBy('name')->get(); $response = new Moto\Json\Response\Collection(); $response->meta->exchangeArray(array( 'total' => $items->count(), 'page' => 1, )); $response->records = $items->toArray(); return $response; } public static function delete($id) { $id = (int) $id; $record = Moto\Database\Models\Font::find($id); if (!$record) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } if ($record->provider === 'system') { throw new Server\Exception(Moto\System\Exception::ERROR_PERMISSION_DENIED_MESSAGE, Moto\System\Exception::ERROR_PERMISSION_DENIED_CODE, array('reason' => 'SYSTEM')); } if ($record->is_protected) { throw new Server\Exception(Moto\System\Exception::ERROR_PERMISSION_DENIED_MESSAGE, Moto\System\Exception::ERROR_PERMISSION_DENIED_CODE, array('reason' => 'PROTECTED')); } $result = $record->delete(); if ($result) { Moto\System\Style::buildFonts(); } return $result; } public static function save($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $isNew = empty($request['id']); if ($isNew) { $filter = new InputFilter\AddFont(); } else { $filter = new InputFilter\UpdateFont(); } $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); if ($isNew) { $record = new Moto\Database\Models\Font(); } else { $record = Moto\Database\Models\Font::find((int) $values['id']); if (!$record) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } } $record->fill($values); $record->active = true; if ($record->save()) { Moto\System\Style::buildFonts(); } return $record; } public function getById($id) { $id = (int) $id; $record = Moto\Database\Models\Font::find($id); if (!$record) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } if ($record->provider && $record->provider !== 'system') { $info = Moto\Application\FontsManager\Service::getFontByFamilyAndProvider($record->name, $record->provider); if ($info) { $record->variants = $info->variants; $record->subsets = $info->subsets; $record->version = $info->version; $record->last_modified = $info->last_modified; $record->save(); } } return $record; } public static function storeFont($request = null) { if (null === $request) { $request = static::getRequest(); } $filter = new InputFilter\StoreFont(); $filter->setData($request->getParams()); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $attributes = $filter->getValues(); $record = new Moto\Database\Models\Font($attributes); if (!$record->save()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE); } return $record; } public static function uploadFontVariant($request = null) { if (null === $request) { $request = static::getRequest(); } Moto\System::checkAndReconnectDatabaseAdapter(); $fileRequest = new Zend\Http\PhpEnvironment\Request(); $filter = new InputFilter\UploadFontVariant(); $filter->setData(array_merge($fileRequest->getFiles()->toArray(), $request->getParams())); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } try { $values = $filter->getValues(); } catch (\Exception $e) { Moto\System\Log::error('[' . __CLASS__ . '::' . __FUNCTION__ . '] : [' . $e->getCode() . '] ' . $e->getMessage(), [ 'request' => $request->getParams(), ]); throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, [ 'exception' => [ 'code' => $e->getCode(), 'message' => $e->getMessage(), ] ]); } Moto\System::checkAndReconnectDatabaseAdapter(); $record = Moto\Database\Models\Font::findOrFail($values['id']); $variant = $record->firstOrNewCustomVariant($values['variant']); if (!$variant) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, [ 'variant' => [ 'noRecordFound', ], ]); } $file = $values['file']; $file['path'] = $file['tmp_name']; if (!$variant->attachFontFile($file)) { @unlink($file['path']); throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, [ 'file' => [ 'notAcceptable', ], ]); } $record->addVariant($variant); if ($values['activate']) { $record->activateVariant($variant->name); } if (!$record->save()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE); } Moto\System\Style::buildFonts(); return $record; } public static function destroyFontVariant($request = null) { if (null === $request) { $request = static::getRequest(); } $filter = new InputFilter\DestroyFontVariant(); $filter->setData($request->getParams()); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $record = Moto\Database\Models\Font::findOrFail($values['id']); $variant = $record->getCustomVariant($values['variant']); if (!$variant) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, [ 'variant' => [ 'noRecordFound', ], ]); } $record->removeVariant($values['variant']); if (!$record->save()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE); } $variant->delete(); Moto\System\Style::buildFonts(); return $record; } } 