<?php
namespace Moto\Application\Installation; use Moto; use Zend\Db; class Restoring extends Moto\Application\Installation\Processor { const RESTORING_SOURCE_DIR = '@websiteBackupSourceDir'; protected $_backupInformation; public function getProcessingMode() { return 'RESTORING'; } public function checkRequirements() { $requirements = parent::checkRequirements(); $validator = new Moto\Application\ServerTest\Validator\Requirements(); $relativePath = $this->getRelativeRestoringPath('index.php'); $validator->addValidator('file_readable', [ 'name' => $relativePath, 'type' => 'file', 'level' => 'error', ]); if (!$validator->isValid()) { $requirements = array_merge($requirements, $validator->getErrors()); } if (!$this->_loadBackupInformation()) { $requirements[] = [ 'name' => 'TODO_RENAME.CANT_LOAD_INFORMATION', 'params' => [ 'name' => $relativePath, ] ]; } return $requirements; } protected function getRestoringPath($file = null) { $path = static::RESTORING_SOURCE_DIR; if (is_string($file)) { $path .= '/' . ltrim($file, '/'); } return $path; } protected function getAbsoluteRestoringPath($file = null) { return Moto\System::getAbsolutePath($this->getRestoringPath($file)); } protected function getRelativeRestoringPath($file = null) { return Moto\System::getRelativePath($this->getRestoringPath($file)); } protected function _loadBackupInformation() { $absolutePath = $this->getAbsoluteRestoringPath('index.php'); if (!is_file($absolutePath)) { return false; } $information = null; ob_start(); try { $information = include($absolutePath); } catch (\Exception $e) { } ob_get_clean(); if (!is_array($information)) { return false; } $this->_backupInformation = $information; return true; } public function getBackupInformation($name = null, $default) { if (!$this->_backupInformation) { $this->_loadBackupInformation(); } return Moto\Util::getValue($this->_backupInformation, $name, $default); } protected function _getAvailablePlugins() { return []; } protected function _getCurrentTheme() { return parent::_getCurrentTheme(); } protected function _getWebsiteDatabaseFiles() { $collection = new Moto\System\BaseCollection(); $collection->push([ 'path' => $this->getRestoringPath('sql/structure.sql'), 'owner' => 'system', 'type' => 'sql', ]); $collection->push([ 'path' => $this->getRestoringPath('sql/content.sql'), 'owner' => 'system', 'type' => 'sql', ]); $collection->push([ 'path' => $this->getRestoringPath('json/content.json'), 'owner' => 'system', 'type' => 'json', ]); return $collection; } protected function _importDataBase() { return parent::_importDataBase(); } protected function _createAdminUser() { $this->_user = Moto\Website\Settings::getWebmasterModel(); Moto\Authentication\Service::setUser($this->_user); } protected function _getRequestValidator() { $validator = parent::_getRequestValidator(); $validator->remove('admin'); return $validator; } protected function _importThemeAndUpgradeContent() { Moto\Website\Theme::init(); } } 