<?php
 namespace Moto\Application\MediaLibrary; use Moto\Json\Request; use Moto\Json\Server; use Moto\Json\Response; use Moto; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'mediaLibrary'; protected static $_resourcePrivilegesMap = array( 'getMediaLibrary' => 'get', 'getMediaLibraryProperties' => 'get', 'getItemById' => 'get', 'getItems' => 'get', 'getFolders' => 'get', 'createFolder' => 'set', 'renameFolder' => 'set', 'updateFolderFavorite' => 'set', 'saveFolders' => 'set', 'storeFile' => 'set', ); public static function getMediaLibrary($request = null) { $result = array(); if (null === $request) $request = static::getRequest()->getParams(); if (!($request instanceof Request\Collection)) $request = new Request\Collection($request); $result['items'] = static::getItems(); $result['folders'] = static::getFolders(); $result['properties'] = static::getMediaLibraryProperties(); return $result; } public static function getMediaLibraryProperties() { return Moto\Application\FileManager\Service::getInfo(); } public static function createFolder($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\NewFolder(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $table = new MediaFoldersTable(); $folder = new MediaFolderModel(); $folder->setFromArray($values); $folder = $table->insert($folder); return $folder; } public static function renameFolder($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\RenameFolder(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $table = new MediaFoldersTable(); $table->useResultAsModel(true); $folder = $table->getById($values['id']); if (!$folder) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $folder->setName($values['name']); $table->update($folder); return $folder; } public static function upload($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } Moto\System::checkAndReconnectDatabaseAdapter(); $filter = new InputFilter\Upload(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $now = time(); $path = date('Y/m/', $now); $dir = Moto\System::getAbsolutePath('@userUploads/' . $path); if (!file_exists($dir)) { Moto\Util::createDir($dir); } Moto\System::checkAndReconnectDatabaseAdapter(); $file = Moto\Application\FileManager\Service::upload(array( 'path' => $path )); Moto\System::checkAndReconnectDatabaseAdapter(); $itemModel = new MediaItemModel(); $itemModel->folder_id = $filter->getValue('folder_id'); $itemModel->is_protected = $filter->getValue('is_protected'); $itemModel->path = $path . basename($file['tmp_name']); $user = Moto\Authentication\Service::getUser(); if ($user) { $itemModel->author_id = $user->id; } $itemModel->setDataFromUploadedFile($file['tmp_name']); $itemModel->name = $file['name']; Moto\System::checkAndReconnectDatabaseAdapter(); $itemTable = new MediaItemsTable(); $itemTable->insert($itemModel); return Moto\Database\Models\MediaItem::find($itemModel->id); } public static function generateThumbnails($request = null) { if (null === $request) $request = static::getRequest()->getParams(); try { if (empty($request['id'])) throw new Server\Exception(); $table = new MediaItemsTable(); $item = $table->getById($request['id']); $explodedPath = explode('/', $item->path); if (sizeof($explodedPath) != 3) throw new Server\Exception(); $path = $explodedPath[0] . '/' . $explodedPath[1] . '/'; $basename = $explodedPath[2]; if (Moto\Features::isEnabled('engine_thumbnails_available')) { Moto\Util::createDir(Moto\System::getAbsolutePath('@userUploads/' . $path . '/thumbnails/')); Moto\Util::generateSystemThumbnails($path, $basename, $item); } return Moto\Database\Models\MediaItem::find($item->id); } catch (Server\Exception $e) { return false; } } public static function getItem($request = null) { if (null === $request) $request = static::getRequest()->getParams(); try { if (empty($request['id'])) throw new Server\Exception(); return Moto\Database\Models\MediaItem::findOrFail($request['id']); } catch (Server\Exception $e) { return false; } } public static function getItemById($id) { return Moto\Database\Models\MediaItem::findOrFail($id); } public static function saveItem($request = null) { if (null === $request) $request = static::getRequest()->getParams(); $filter = new InputFilter\SaveItem(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $item = Moto\Database\Models\MediaItem::findOrFail($values['id']); $item->fill($values); $item->save(); return $item; } public static function deleteItems($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } if (array_key_exists('id', $request)) { $request['id'] = is_array($request['id']) ? $request['id'] : array($request['id']); } $filter = new InputFilter\DeleteItem(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $itemIds = $filter->getValue('id'); $table = new MediaItemsTable(); $table->useResultAsModel(true); $result = false; foreach ($itemIds as $id) { $item = $table->getById($id); if (!$item) { continue; } Moto\Hook::trigger(Moto\Hook::MEDIA_LIBRARY_ITEM_DELETING, $item); if ($item->is_protected) { throw new Server\Exception(Moto\System\Exception::ERROR_PERMISSION_DENIED_MESSAGE, Moto\System\Exception::ERROR_PERMISSION_DENIED_CODE, array('reason' => 'PROTECTED')); } try { Moto\Application\FileManager\Service::delete(array('path' => $item->path)); } catch (Server\Exception $e) { $errors = $e->getErrors(); if (Moto\Util::getValue($errors, 'path.0') !== 'notExists') { throw new Server\Exception(Moto\System\Exception::ERROR_CAN_NOT_DELETE_MESSAGE, Moto\System\Exception::ERROR_ACTION_NOT_ACCEPTABLE_CODE); } } $thumbnails = $item->getThumbnails(); if ($thumbnails) { foreach ($thumbnails as $thumbnailName => $meta) { try { $thumbnail = $item->getThumbnail($thumbnailName); if (!empty($thumbnail->path)) { Moto\Application\FileManager\Service::delete(array('path' => $thumbnail->path)); } } catch (\Exception $e) { } } } $result |= $table->deleteById($id); Moto\Hook::trigger(Moto\Hook::MEDIA_LIBRARY_ITEM_DELETED, $item); } return $result; } public static function deleteFolders($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } if (array_key_exists('id', $request)) { $request['id'] = is_array($request['id']) ? $request['id'] : array($request['id']); } $filter = new InputFilter\DeleteFolder(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $itemIds = $filter->getValue('id'); $foldersTable = new MediaFoldersTable(); $itemsTable = new MediaItemsTable(); $foldersTable->useResultAsModel(true); $result = false; foreach ($itemIds as $id) { $childItemsList = $itemsTable->getList(array('folder_id' => $id)); if (count($childItemsList['records']) > 0) { foreach ($childItemsList['records'] as $item) { static::deleteItems(array('id' => $item['id'])); } } $result |= $foldersTable->deleteById($id); } return $result; } public static function updateFolderFavorite(Moto\Json\Server\Request $request = null) { if ($request === null) { $request = static::getRequest(); } $errors = []; $id = (int)$request->getParam('id'); if ($id < 1) { $errors['id'] = ['isEmpty']; } if (!$request->issetParam('is_favorite')) { $errors['is_favorite'] = ['isEmpty']; } if (count($errors) > 0) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $errors); } $table = new MediaFoldersTable(); $table->useResultAsModel(true); $record = $table->getById($id); if (!$record) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, [ 'id' => [ 'noRecordFound', ], ]); } $record->is_favorite = (boolean)$request->getParam('is_favorite'); $table->save($record); return $record; } public static function moveItems($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\MoveItems(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $table = new MediaItemsTable(); $table->update(array( 'folder_id' => $filter->getValue('folder_id') ), array( 'id' => $filter->getValue('id') )); return true; } public static function saveFolders($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\SaveFolders(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $table = new MediaFoldersTable(); $table->useResultAsModel(true); $foldersTree = $filter->getValue('folders'); foreach ($foldersTree as $folder) { $table->update($folder, array('id' => $folder['id'])); } return static::getFolders(); } public static function getItems() { $query = Moto\Database\Models\MediaItem::query(); $collection = $query->get(); $response = new Moto\Json\Response\Collection(); $response->meta->exchangeArray(array( 'total' => $collection->count(), 'page' => 0, )); $response->records = $collection->toArray(); return $response; } public static function getFolders() { $query = Moto\Database\Models\MediaFolder::query(); $items = $query->orderBy('created', 'ASC')->get(); $response = new Moto\Json\Response\Collection(); $response->meta->exchangeArray([ 'total' => $items->count(), 'page' => 1, ]); $response->records = $items->toArray(); return $response; } public static function updateItems($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } if (array_key_exists('id', $request)) { $request['id'] = is_array($request['id']) ? $request['id'] : array($request['id']); } $filter = new InputFilter\UpdateItems(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $request = $filter->getValues(); $itemTable = new MediaItemsTable(); $itemTable->updateItems($request['id'], $request['update']); return Moto\Database\Models\MediaItem::query()->whereIn('id', $request['id'])->get()->toArray(); } public static function downloadFile($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\DownloadFile(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $url = $filter->getValue('url'); $options = array( 'maxredirects' => 1, 'curloptions' => array( CURLOPT_CONNECTTIMEOUT => 5, CURLOPT_TIMEOUT => 25, ) ); $info = parse_url($url); if (isset($info['scheme'])) { $info['scheme'] = strtolower($info['scheme']); if ($info['scheme'] == 'https') { $options['curloptions'][CURLOPT_SSL_VERIFYPEER] = false; $options['curloptions'][CURLOPT_SSL_VERIFYHOST] = 0; } } $client = new Moto\Http\Client($url, $options); $client->setStream(); $response = $client->send(); if ($client->hasErrors()) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('MEDIA_LIBRARY : download file', array('url' => $url, 'errors' => $client->getErrors())); } throw new Server\Exception('COMMON.ERROR.DOWNLOAD_FAILED', 500, $client->getErrors()); } $client->getAdapter()->close(); $table = new MediaItemsTable(); $table->useResultAsModel(true); $tempFilePath = $response->getStreamName(); $fileName = $filter->getValue('filename'); $fileInfo = pathinfo($fileName); $fileName = $fileInfo['filename'] . '_' . date('Y-m-d-H-i-s') . '.' . $fileInfo['extension']; $filePath = date('Y/m') . '/' . $fileName; if (!Moto\Util::copyFile($tempFilePath, Moto\System::getAbsolutePath('@userUploads/' . $filePath), true)) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('MEDIA_LIBRARY : cant move new file', array('tempFilePath' => $tempFilePath, 'filePath' => $filePath)); } throw new Server\Exception('COMMON.ERROR.DOWNLOAD_FAILED', 500, array('errors' => array('filename' => 'ERROR_CANT_COPY_FILE'))); } $item = new MediaItemModel(); $item->folder_id = $filter->getValue('folder_id'); $item->path = $filePath; $user = Moto\Authentication\Service::getUser(); if ($user) { $item->author_id = $user->id; } $item->setDataFromUploadedFile(); $item->name = $fileName; $table->insert($item); return Moto\Database\Models\MediaItem::find($item->id); } public static function storeFile($request = null) { if (!($request instanceof Moto\Json\Server\Request)) { $request = static::getRequest(); } $filter = new InputFilter\StoreFile(); $data = $request->getParams(); $filter->setData($data); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $user = Moto\Authentication\Service::getUser(); if (!$user) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, [ 'user' => ['ERROR_CANT_FIND_USER'], ]); } $table = new MediaItemsTable(); $table->useResultAsModel(true); $item = new MediaItemModel(); $item->folder_id = $values['folder_id']; $item->path = $values['file_path']; $item->author_id = $user->id; $content = $values['content']; if ($values['encoding'] === 'base64') { $content = base64_decode($content); } $absolutePath = Moto\System::getUploadAbsolutePath($values['file_path']); if (empty($absolutePath)) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, [ 'file_path' => ['ERROR_CANT_RESOLVE_FILE_PATH'], ]); } $written = Moto\Util::filePutContents($absolutePath, $content); if (!$written) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('MEDIA_LIBRARY : cant save file content', array('filename' => $values['file_path'], 'contentSize' => strlen($values['content']))); } throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, [ 'content' => ['ERROR_CANT_WRITE_FILE'], ]); } $item->setDataFromUploadedFile(); $item->name = $values['name']; $table->insert($item); return Moto\Database\Models\MediaItem::find($item->id); } } 