<?php
namespace Moto\Application\Menus; use Moto\Application\Model; use Moto\Application\Model\AbstractModel; use Moto\Application\Util\Generator; use Moto; class MenuModel extends AbstractModel { protected $_fields = array( 'id' => array(), 'name' => array( 'default' => '' ), 'is_system' => array( 'default' => 0 ), 'modified' => array(), 'created' => array(), ); public function __construct() { parent::__construct(); $this->created = date('Y-m-d H:i:s'); $this->modified = $this->created; } public function toInsert() { $data = parent::toInsert(); return $data; } public function toUpdate() { $this->modified = date('Y-m-d H:i:s'); $data = parent::toUpdate(); return $data; } public function exchangeArray($data) { parent::exchangeArray($data); } public function __clone() { $this->id = null; $this->is_system = 0; $this->created = date('Y-m-d H:i:s'); $this->modified = $this->created; } public function duplicate() { $newMenu = clone $this; $uniqueNameFilter = new Moto\Filter\Duplicate(array( 'duplicator' => array( 'name' => 'db', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'menus', 'field' => 'name' ) ) )); $newMenu->name = $uniqueNameFilter->filter($this->name); return $newMenu; } public function duplicateItemsFromMenu($menuId) { $table = new MenuItemsTable(); $collection = $table->getList(array('menu_id' => $menuId)); if (empty($collection['records'])) return true; $items = array(); foreach ($collection['records'] as $record) { $items[$record['id']] = $record; } $filter = new InputFilter\NewMenuItem(); reset($items); foreach ($items as $oldId => $item) { if (is_string($item['properties'])) { $item['properties'] = json_decode($item['properties'], true); } $filter->setData($item); if (!$filter->isValid()) { continue; } $values = $filter->getValues(); $values['menu_id'] = $this->id; $values['status'] = $item['status']; $menuItem = new MenuItem(); $menuItem->setFromArray($values); $menuItem = $table->insert($menuItem); $items[$oldId]['newId'] = $menuItem->id; } reset($items); foreach ($items as $item) { if (empty($item['parent_id'])) { continue; } $where = array( 'id' => $item['newId'] ); $update = array( 'parent_id' => 0 ); if (isset($items[$item['parent_id']])) { $update['parent_id'] = $items[$item['parent_id']]['newId']; } $table->update($update, $where); } return true; } }