<?php
namespace Moto\Application\Menus; use Moto\Json\Server; use Moto\Json\Request; use Moto\Json\Response; use Moto\Application\Menus\MenusTable; use Moto; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'menus'; protected static $_resourcePrivilegesMap = array( 'getList' => 'get', 'getById' => 'get', 'getItemsList' => 'get', ); public static function getList($request = null) { if (null === $request) $request = static::getRequest()->getParams(); if (!($request instanceof Request\Collection)) $request = new Request\Collection($request); $table = new MenusTable(); $items = $table->getList($request); $result = new Response\Collection($items); return $result; } public static function save($request = null) { if (null === $request) $request = static::getRequest()->getParams(); if (empty($request['id'])) { return static::_addMenu($request); } else { return static::_updateMenu($request); } } protected static function _addMenu($data) { $filter = new NewMenuFilter(); $filter->setData($data); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $table = new MenusTable(); $menu = new MenuModel(); $menu->setFromArray($values); $menu = $table->insert($menu); return $menu; } protected static function _updateMenu($data) { $filter = new InputFilter\Save(); $filter->setData($data); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $itemsTree = $values['items']; $table = new MenusTable(); $table->useResultAsModel(true); $menu = $table->getById($values['id']); if (!$menu) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $menu->setFromArray($values); $table->update($menu); $table = new MenuItemsTable(); $itemsFromDb = $table->getList(array('menu_id' => $values['id'])); $getItemFromRequest = function ($searchId) use (&$itemsTree) { $foundItem = null; foreach ($itemsTree as $item) { if ($item['id'] == $searchId) { $foundItem = $item; break; } } return $foundItem; }; if ($itemsFromDb['meta']['total'] > 0) { foreach ($itemsFromDb['records'] as $itemFromDb) { $foundTreeItem = $getItemFromRequest($itemFromDb['id']); if ($foundTreeItem) { $menuItem = new MenuItem(); $data = array_merge((array)$itemFromDb, $foundTreeItem); $menuItem->setFromArray($data); $menuItem->publish(); $table->update($menuItem); } else { $table->deleteById($itemFromDb['id']); } } } return $menu; } public static function delete($id) { $table = new MenusTable(); $menu = $table->getById($id); if (!$menu) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } if ($menu->is_system) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } return $table->deleteById($menu->id); } public static function getById($id) { $table = new MenusTable(); $page = $table->getById($id); if (!$page) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } return $page; } public static function duplicate($id) { $table = new MenusTable(); $table->useResultAsModel(true); $menu = $table->getById($id); if (!$menu) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $filter = new InputFilter\Duplicate(); $filter->setData(array( 'name' => $menu->name )); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $newMenu = $menu->duplicate(); $table->insert($newMenu); $newMenu->duplicateItemsFromMenu($menu->id); return $newMenu; } public static function getItemsList($id, $onlyPublished = false) { $table = new MenuItemsTable(); if (!is_numeric($id)) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE); } $where = array('menu_id' => $id); if ($onlyPublished) { $where['status'] = 'publish'; } $items = $table->getList($where); if (!$items) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $result = new Response\Collection($items); return $result; } public static function saveItem($request = null) { if (null === $request) $request = static::getRequest()->getParams(); if (empty($request['id'])) { return static::_addMenuItem($request); } else { return static::_updateMenuItem($request); } } protected static function _addMenuItem($data) { $filter = new InputFilter\NewMenuItem(); $filter->setData($data); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $table = new MenuItemsTable(); $menuItem = new Moto\Application\Menus\MenuItem(); $menuItem->setFromArray($values); $menuItem = $table->insert($menuItem); return $menuItem; } protected static function _updateMenuItem($data) { $filter = new InputFilter\SaveMenuItem(); $filter->setData($data); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $table = new MenuItemsTable(); $table->useResultAsModel(true); $menuItem = $table->getById($values['id']); if (!$menuItem) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $menuItem->setFromArray($values); $table->update($menuItem); return $menuItem; } }