<?php
namespace Moto\Application\Pages\InputFilter; use Moto\InputFilter\AbstractInputFilter; use Moto; class NewPage extends AbstractInputFilter { protected $_name = 'pages.new'; public function init() { $this->add(array( 'name' => 'name', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 200, ), ), ), )); $this->add(array( 'name' => 'parent_id', 'required' => true, 'allow_empty' => true, 'filters' => array( array('name' => 'Moto\Application\Pages\ZeroFilter'), array( 'name' => 'Moto\Filter\DefaultFilter', 'options' => array( 'value' => 0 ) ), ), 'continue_if_empty' => true, 'validators' => array( array( 'name' => 'Digits', 'break_chain_on_failure' => true, ), array( 'name' => 'Moto\Validator\ParentId', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'pages', 'field' => 'id', 'adapter' => Moto\Config::get('databaseAdapter'), ) ) ), )); $this->add(array( 'name' => 'url', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), array('name' => 'StringToLower'), ), 'validators' => array( array( 'name' => 'Regex', 'break_chain_on_failure' => true, 'options' => array( 'pattern' => '/^([a-z0-9\_\-]{1,200})$/', ) ), array( 'name' => 'Moto\Application\Pages\PageParentUrlValidator', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'pages', 'field' => 'url', 'adapter' => Moto\Config::get('databaseAdapter') ) ) ), )); $this->add(array( 'name' => 'content', 'required' => false, 'filters' => array( array('name' => 'StringTrim'), array('name' => 'Moto\Filter\StripCode'), array('name' => 'Moto\Filter\BodyContent'), ), )); $this->add(array( 'name' => 'author_id', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), array( 'name' => 'Moto\Filter\DefaultFilter', 'options' => array( 'value' => 1 ) ), ), 'validators' => array( array( 'name' => 'Digits', 'break_chain_on_failure' => true, ), array( 'name' => 'Db\RecordExists', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'users', 'field' => 'id', 'adapter' => Moto\Config::get('databaseAdapter') ) ) ), )); $this->add(array( 'name' => 'type', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), array( 'name' => 'Moto\Filter\DefaultFilter', 'options' => array( 'value' => 'page' ) ), ), 'validators' => array( array( 'name' => 'Regex', 'break_chain_on_failure' => true, 'options' => array( 'pattern' => '/^([a-z0-9\_\-\.]{1,48})$/', ) ), ), )); $this->add(array( 'name' => 'status', 'required' => true, 'filters' => array( array('name' => 'StringTrim'), array( 'name' => 'Moto\Filter\DefaultFilter', 'options' => array( 'value' => 'draft' ) ), ), 'validators' => array( array( 'name' => 'InArray', 'options' => array( 'haystack' => array('publish', 'draft') ) ), ), )); $this->add(array( 'name' => 'visibility', 'required' => true, 'filters' => array( array('name' => 'StringTrim'), array( 'name' => 'Moto\Filter\DefaultFilter', 'options' => array( 'value' => 'public' ) ), ), 'validators' => array( array( 'name' => 'InArray', 'options' => array( 'haystack' => array('public', 'password', 'private') ) ), ), )); $this->add(array( 'name' => 'layout', 'required' => false, 'allow_empty' => true, 'filters' => array( array( 'name' => 'Moto\Filter\DefaultFilter', 'options' => array( 'value' => '' ) ) ) )); $this->add(array( 'name' => 'short_description', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'Moto\Filter\StripCode'), array('name' => 'Moto\Filter\BodyContent'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 0, 'max' => 16000, ), ), ), )); $this->add(array( 'name' => 'category_id', 'required' => false, 'filters' => array( array('name' => 'StringTrim'), array('name' => 'Moto\Filter\IntValue'), array( 'name' => 'Moto\Filter\DefaultFilter', 'options' => array( 'value' => null ) ), ), 'validators' => array( array( 'name' => 'Moto\Validator\Db\RecordExists', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'content_taxonomies', 'field' => 'id', 'allow_zero' => true, 'allow_null' => true, ) ) ), )); } public function getValues($keys = null, $ignoreDefault = false) { $values = parent::getValues($keys, $ignoreDefault); if (empty($values['layout'])) { unset($values['layout']); } return $values; } public function setData($data) { if (!empty($data['type']) && (empty($data['parent_id']) || $data['parent_id']*1 == 0 )) { $pageType = Moto\Website\PageType::get($data['type']); if ( $pageType->isPost() && (empty($data['id']) || $pageType->getMainPageId() != $data['id'])) { $data['parent_id'] = $pageType->getMainPageId(); } } $result = parent::setData($data); return $result; } } 