<?php
 namespace Moto\Application\Pages; use Moto\Validator\AbstractValidator; use Moto; class PageVisibilityParamsValidator extends AbstractValidator { const BROKEN_SCHEMA = 'brokenSchema'; const EMPTY_PASSWORD = 'emptyPassword'; const ROLE_NOT_EXISTS = 'roleNotExists'; protected $messageTemplates = array( self::BROKEN_SCHEMA => 'Broken request schema', self::EMPTY_PASSWORD => 'Password is not specified', self::ROLE_NOT_EXISTS => 'Specified role id doesn\'t exist', ); public function isValid($params, array $context = null) { $this->setValue($params); $isValid = array_key_exists('type', $context); if (!$isValid) { $this->error(self::BROKEN_SCHEMA); return false; } $isValid = false; switch ($context['type']) { case 'public': $isValid = true; break; case 'protected': if (is_array($params) && array_key_exists('password', $params)) { $isValid = !empty($params['password']) && is_string($params['password']); if (!$isValid) { $this->error(self::EMPTY_PASSWORD); } return $isValid; } break; case 'private': if (is_array($params) && array_key_exists('role_id', $params)) { $validator = new \Zend\Validator\Db\RecordExists( array( 'table' => Moto\Config::get('database.prefix') . 'roles', 'field' => 'id', 'adapter' => Moto\Config::get('databaseAdapter') ) ); $isValid = $validator->isValid($params['role_id']); if (!$isValid) { $this->error(self::ROLE_NOT_EXISTS); } return $isValid; } break; default: break; } if (!$isValid) { $this->error(self::BROKEN_SCHEMA); } return $isValid; } } 