<?php
 namespace Moto\Application\Pages; use ArrayObject; use Moto; use Moto\Application\Model\AbstractModel; use Moto\Application\Model\AbstractTable; use Zend\Db\ResultSet\ResultSet; use Zend\Db\Sql\Expression as SqlExpression; use Zend\Db\Sql\Predicate\NotLike; use Zend\Db\Sql\Select; use Zend\Paginator; use Zend\Validator\Db\NoRecordExists as ValidatorDbNoRecordExists; class PagesTable extends AbstractTable { protected $table = 'pages'; protected $_resultModel = 'Moto\Application\Pages\PageModel'; protected $_primaryKey = 'id'; protected $_defaultFieldsForSelect = array('id', 'name', 'url', 'title', 'author_id', 'parent_id', 'category_id', 'is_system', 'type', 'status', 'visibility', 'properties', 'layout', 'styles', 'published', 'background_id', 'short_description', 'modified', 'created'); protected $_tree = null; public function __construct() { parent::__construct(); $options = array( 'treepath' => 'pages_treepath' ); $this->_tree = new Moto\Application\Util\Tree\ClosureTable($this, $options); } public function getClosureTable() { return $this->_tree; } public function fetchAll() { $resultSet = $this->select(); return $resultSet; } public function getPaginator($where = null, $order = null) { $select = new Select($this->table); if (isset($where)) { $select->where($where); } if (is_array($order)) { $select->order($order); } $paginatorAdapter = new Paginator\Adapter\DbSelect( $select, $this->getAdapter(), $this->resultSetPrototype ); $paginator = new Paginator\Paginator($paginatorAdapter); return $paginator; } public function getList($where = null, $columns = null, $order = null, $limit = null) { $select = new Select($this->table); $select->columns(array( 'count' => new SqlExpression("COUNT(*)") )); if (!empty($where)) { $select->where($where); } $objectPrototype = $this->resultSetPrototype->getArrayObjectPrototype(); if ($this->_usedResultModel) { $this->resultSetPrototype->setArrayObjectPrototype(new ArrayObject(array(), ArrayObject::ARRAY_AS_PROPS)); } $result = $this->executeSelect($select); $total = $result->current()->count; if ($this->_usedResultModel) { $this->resultSetPrototype->setArrayObjectPrototype($objectPrototype); } if (null === $columns) { $columns = $this->_defaultFieldsForSelect; } if (!is_array($columns)) { $columns = array($columns); } $select->columns($columns); if ($order) { $select->order($order); } else { $select->order(array('id' => 'ASC')); } if ($limit) { $select->limit($limit); } $records = $this->fetchFromResultSet($this->executeSelect($select)); $result = array( 'meta' => array( 'total' => $total, 'limit' => 0, 'page' => 0, ), 'records' => $records ); return $result; } public function getById($id, $where = null) { $row = is_numeric($id); if ($row) { $select = new Select($this->table); $select->where(array( 'id' => $id )); if (!empty($where)) { $select->where($where); } $resultSet = $this->executeSelect($select); $row = $resultSet->current(); } return $row; } public function getByUrl($url) { $url = trim((string) $url, ' /'); $path = explode('/', $url); $root = $path[0]; $page = false; $this->useResultAsModel(true); if (count($path) > 1) { $rootPage = $this->getByUrl($root); if ($rootPage) { $tree = $rootPage->buildChildrenPlainTree(); if (array_key_exists($url, $tree) && isset($tree[$url]['id'])) { $page = $this->getById($tree[$url]['id']); } } } elseif (count($path) == 1) { $select = new Select($this->table); $select->where(array( 'url' => $root, 'parent_id' => 0 )); $resultSet = $this->executeSelect($select); $page = $resultSet->current(); } return $page; } public function update($model, $where = null, $skipCreatingRevision = false) { $skipCreatingRevision = true; $revision = null; if (!$skipCreatingRevision && $this->_resultModel && $model instanceof $this->_resultModel && $model->isModified()) { $revision = $this->create($model->getCleanData()); } $removedContainers = array(); if ($model instanceof $this->_resultModel && $model->isModified('content') && !empty($model->content) && is_string($model->content)) { $originalContainers = Moto\Application\Content\Util::findContainers(trim($model->getOriginal('content', ''))); $currentContainers = Moto\Application\Content\Util::findContainers(trim($model->content)); $removedContainers = array_diff($originalContainers, $currentContainers); } $result = parent::update($model, $where); if (null !== $result && null !== $revision && !$skipCreatingRevision) { $revision->id = null; $user = Moto\Authentication\Service::getUser(); if ($user) { $revision->author_id = $user->id; } $revision->parent_id = $model->id; $revision->type = 'revision'; $revision->url = 'rev-' . $model->id . '-' . time() . '-' . uniqid(); $revision->created = date('Y-m-d H:i:s'); parent::insert($revision); } if (Moto\Util::getValue($model, 'id') > 0 && Moto\Util::getValue($model, 'parent_id') !== null) { $this->_tree->moveNode(Moto\Util::getValue($model, 'id'), Moto\Util::getValue($model, 'parent_id')); } if (!empty($removedContainers)) { $table = new Moto\Application\Styles\StylesTable(); $table->deleteByClassName($removedContainers); } return $result; } public function getRevisionListByPageId($id) { $id = (int) $id; $select = new Select($this->table); $select->columns(array( 'count' => new SqlExpression("COUNT(*)") )); $select->where(array( 'parent_id' => $id, 'type' => array('revision'), )); $result = $this->executeSelect($select); $total = $result->current()->count; $select->columns(array('id', 'name', 'url', 'title', 'author_id', 'parent_id', 'type', 'status', 'visibility', 'properties', 'layout', 'styles', 'published', 'modified', 'created')); $select->order(array('id' => 'DESC')); $records = $this->executeSelect($select); $result = array( 'meta' => array( 'total' => $total, 'limit' => 0, 'page' => 0, ), 'records' => $records->toArray() ); return $result; } public function getRevisionById($id) { $id = (int) $id; $select = new Select($this->table); $select->where(array( 'id' => $id, )); $result = $this->executeSelect($select); $revision = $result->current(); return $revision; } public function createDuplicate(PageModel $page) { $newPage = $page->duplicate(); $styles = array(); $containers = Moto\Application\Content\Util::findContainers($newPage->content); if (!empty($containers)) { $styleTable = new Moto\Application\Styles\StylesTable(); $styleTable->useResultAsModel(true); foreach ($containers as $containerClassName) { $newClassName = 'moto-container_content_' . Moto\Util::getUniqueId(); $style = $styleTable->getByClassName($containerClassName); if ($style) { $newStyle = $styleTable->duplicate($style); $newStyle->name = $newStyle->class_name = $newClassName; $styles[] = $newStyle; } $newPage->content = str_replace($containerClassName, $newClassName, $newPage->content); } } $this->insert($newPage); if (!empty($styles)) { foreach ($styles as $style) { $styleTable->save($style); } Moto\System\Style::rebuildAll(); } $taxonomies = $page->loadRelation('taxonomies')->taxonomies; if ($taxonomies->isNotEmpty()) { $newPage->syncTaxonomies($taxonomies); } return $newPage; } public function deleteById($id, $newChildrenParentId = null) { $this->_tree->delete(array('id' => $id)); if (!is_null($newChildrenParentId)) { $children = $this->getChildren($id); if (!empty($children)) { foreach ($children as $child) { $select = new Select($this->table); $select->where->equalTo('url', null); $select->where->equalTo('parent_id', $newChildrenParentId); $notExistValidator = new ValidatorDbNoRecordExists($select); $notExistValidator->setAdapter(Moto\Config::get('databaseAdapter')); if ($notExistValidator->isValid($child['url'])) { parent::update(array('parent_id' => $newChildrenParentId), array('id' => $child['id'])); } else { $child['parent_id'] = $newChildrenParentId; $model = new PageModel(); $model->setFromArray($child); $duplicateOnlyUrl = true; $model = $model->duplicate($duplicateOnlyUrl); $model->id = $child['id']; parent::update($model); } } } } $where = array( 'type' => 'revision', 'parent_id' => $id ); $this->delete($where); return true; } public function deletePage($page) { $containers = array(); if (!empty($page->content)) { $containers = Moto\Application\Content\Util::findContainers(trim($page->content)); } $page->onDeletingHandler(); $result = $this->deleteById($page->id, $page->parent_id); if (!empty($containers)) { $table = new Moto\Application\Styles\StylesTable(); $table->deleteByClassName($containers); } $page->onDeletedHandler(); return $result; } public function getChildren($id) { $id = (int) $id; $select = new Select($this->table); $select->where(array( 'parent_id' => $id )); $select->where(new NotLike('url', 'rev-' . $id . '-%')); return $this->executeSelect($select)->toArray(); } public function deleteByAuthorId($id) { $id = (int) $id; $pages = $this->_getList(array('author_id' => $id), array('id')); if (!empty($pages)) { $ids = Moto\Util::arrayValuesAssoc($pages, 'id'); $where = array( 'type' => 'revision', 'parent_id' => $ids ); $this->delete($where); } $where = array( 'author_id' => $id ); $this->delete($where); return true; } public function reassignAuthor($authorId, $newAuthorId) { $authorId = (int) $authorId; $newAuthorId = (int) $newAuthorId; $update = array( 'author_id' => $newAuthorId ); $where = array( 'author_id' => $authorId ); $this->update($update, $where); return true; } protected function _postInsert($model) { parent::_postInsert($model); $this->getClosureTable()->insertNode(Moto\Util::getValue($model, 'id'), Moto\Util::getValue($model, 'parent_id')); if ($model instanceof Moto\Application\Pages\PageModel) { $model->resetModifiedFields(); $model->onCreatedHandler(); } } protected function _postUpdate($model) { parent::_postUpdate($model); } public function getParentBranch($id) { return $this->_tree->getParentBranch($id); } } 