<?php
 namespace Moto\Application\Pages; use Illuminate; use Moto; use Moto\Json\Response; use Moto\Json\Server; use Zend\EventManager\Event; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'pages'; protected static $_resourcePrivilegesMap = array( 'getList' => 'get', 'getById' => 'getPage', 'getMainPage' => 'getPage', 'getRevisionsList' => 'get', 'getRevisionById' => 'get', 'getRelativeUrl' => 'get', ); public static function eventUserDeleteHandler(Event $event) { if ($event->getParam('reassign') === null) { $result = static::_eventUserDeleteRemove($event); } else { $result = static::_eventUserDeleteReassign($event); } return $result; } protected static function _eventUserDeleteRemove(Event $e) { $table = new PagesTable(); return $table->deleteByAuthorId($e->getTarget()->id); } protected static function _eventUserDeleteReassign(Event $e) { $table = new PagesTable(); return $table->reassignAuthor($e->getTarget()->id, $e->getParam('reassign')); } public static function getList($request = null) { $request = static::getRequest(); $type = $request->getParam('type'); $query = Moto\Database\Page::query(); if ($type) { if (is_array($type)) { $query->whereIn('type', $type); } else { $query->where('type', '=', $type); } } $query->with([ 'tags' => function ($query) { $query->addSelect(['id', 'name', 'slug', 'type', 'created_at',]); $query->orderBy('name'); }, 'category' => function ($query) { $query->addSelect(['id', 'name', 'slug', 'type',]); }, 'taxonomies' => function ($query) { $query->addSelect(['id', 'name', 'slug', 'type', 'created_at',]); $query->orderBy('name'); }, ]); $items = $query->get(array( 'id', 'name', 'url', 'title', 'author_id', 'parent_id', 'category_id', 'is_system', 'type', 'status', 'visibility', 'properties', 'layout', 'styles', 'published', 'background_id', 'short_description', 'modified', 'created', )); $response = new Moto\Json\Response\Collection(); $response->meta->exchangeArray(array( 'total' => $items->count(), 'page' => 0, )); $response->records = $items->toArray(); return $response; } public static function save($request = null) { if (null === $request) $request = static::getRequest()->getParams(); if (Moto\Util::arrayHas($request, 'content_data')) { return static::saveAsObject($request); } if (empty($request['id'])) { return static::_addPage($request); } else { return static::_updatePage($request); } } protected static function _addPage($data) { Moto\System::gate()->authorize('create', PageModel::class); $filter = new InputFilter\NewPage(); $filter->setData($data); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $table = new PagesTable(); $page = new PageModel(); $page->setFromArray($values); $user = Moto\Authentication\Service::getUser(); $page->author_id = $user->id; $page = $table->insert($page); return $page; } protected static function _updatePage($data) { $filter = new InputFilter\SavePage(); $filter->setData($data); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); $table = new PagesTable(); $table->useResultAsModel(true); $page = $table->getById($values['id']); if (!$page) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } Moto\System::gate()->authorize('update', $page); $page->setFromArray($values); if ($table->update($page)) { if (Moto\Util::arrayHas($values, 'taxonomies')) { $page->syncTaxonomies($values['taxonomies']); } } $query = Moto\Database\Page::query(); $query->with([ 'tags' => function ($query) { $query->addSelect(['id', 'name', 'slug', 'type', 'created_at',]); $query->orderBy('order_position'); }, 'category' => function ($query) { $query->addSelect(['id', 'name', 'slug', 'type',]); }, 'taxonomies' => function ($query) { $query->addSelect(['id', 'name', 'slug', 'type', 'created_at',]); $query->orderBy('order_position'); }, ]); return $query->find($page->id); } public static function saveAsObject($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $isNew = empty($request['id']); if ($isNew) { $filter = new InputFilter\NewPageAsObject(); } else { $filter = new InputFilter\SavePageAsObject(); } $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); $table = new PagesTable(); $table->useResultAsModel(true); if ($isNew) { Moto\System::gate()->authorize('create', PageModel::class); $page = new PageModel(); } else { $page = $table->getById($values['id']); if (!$page) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } Moto\System::gate()->authorize('update', $page); } $page->setFromArray($values); $table->save($page); $page->getRelativeUrl(); return $page->toArray(); } public static function publish($id) { $table = new PagesTable(); $table->useResultAsModel(true); $page = $table->getById($id); if (!$page) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } Moto\System::gate()->authorize('update', $page); $page->status = PageModel::STATUS_PUBLISH; $table->update($page); return true; } public static function getById($id) { $id = (int) $id; $table = new PagesTable(); $table->useResultAsModel(true); $where = Moto\System::getUser() ? null : array('status' => PageModel::STATUS_PUBLISH); $page = $table->getById($id, $where); if (!$page) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $page->getRelativeUrl(); if (!$page->isTemplate()) { $page->loadRelation([ 'tags' => function ($query) { $query->addSelect(['id', 'name', 'slug', 'type', 'created_at',]); }, ]); } return $page; } public static function getRevisionsList($id) { $id = (int) $id; $table = new PagesTable(); $items = $table->getRevisionListByPageId($id); if (!$items) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $result = new Response\Collection($items); return $result; } public static function restoreFromRevision($id) { $id = (int) $id; $table = new PagesTable(); $table->useResultAsModel(true); $revision = $table->getRevisionById($id); if (!$revision) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE, array('revision' => array('noRecordFound'))); } $revision->setSkipDefaults(false); $page = $table->getById($revision->parent_id); if (!$page) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE, array('page' => array('noRecordFound'))); } $page->setFromRevision($revision); $table->update($page); return $page; } public static function duplicate($id) { Moto\System::gate()->authorize('create', PageModel::class); $id = (int) $id; $table = new PagesTable(); $table->useResultAsModel(true); $page = $table->getById($id); if (!$page) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } Moto\System::gate()->authorize('duplicate', $page); $newPage = $table->createDuplicate($page); return $newPage; } public static function setVisibility($request) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\PageVisibility(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $table = new PagesTable(); $table->useResultAsModel(true); $page = $table->getById($values['id']); if (!$page) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } Moto\System::gate()->authorize('update', $page); $page->visibility = $values['type']; $data = array( 'password' => null, 'role_id' => null ); if ($values['type'] == 'protected') { $data['password'] = $values['params']['password']; } if ($values['type'] == 'private') { $data['role_id'] = $values['params']['role_id']; } $page->properties->setFromArray($data); return $table->update($page); } public static function delete($id) { $id = (int) $id; $table = new PagesTable(); $table->useResultAsModel(true); $page = $table->getById($id); if (!$page) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } if ($page->is_system) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } Moto\System::gate()->authorize('delete', $page); return $table->deletePage($page); } public static function getMainPage() { static $mainPage = null; if ($mainPage) { return $mainPage; } $mainPage = static::getById(Moto\Website\Settings::get('main_page')); return $mainPage; } public static function setMainPage($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } if (!array_key_exists('id', $request) && !is_numeric($request['id'])) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE, array('main_page' => array('noRecordFound'))); } static::publish($request['id']); Moto\Website\Settings::set('main_page', $request['id']); return true; } public static function getRevisionById($id) { $id = (int) $id; $table = new PagesTable(); $table->useResultAsModel(true); $revision = $table->getRevisionById($id); if (!$revision) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE, array('revision' => array('noRecordFound'))); } return $revision; } public static function getRelativeUrl($id) { try { return Moto\Website\Pages::getRelativeUrl($id); } catch (\Exception $e) { throw new Server\Exception($e->getMessage(), $e->getCode(), $e->getErrors()); } } public static function deleteByAuthorId($id) { $table = new PagesTable(); $id = (int) $id; Moto\System::gate()->authorize('deleteByAuthorId', $id); return $table->deleteByAuthorId($id); } public static function reassignAuthor($authorId, $newAuthorId) { $filter = new InputFilter\ReassignAuthor(); $filter->setData(array( 'author_id' => $authorId, 'new_author_id' => $newAuthorId )); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $table = new PagesTable(); Moto\System::gate()->authorize('reassignAuthor'); return $table->reassignAuthor($filter->getValue('author_id'), $filter->getValue('new_author_id')); } public static function preRenderContent($id) { $id = (integer) $id; $table = new PagesTable(); $table->useResultAsModel(true); $record = $table->getById($id); if (!$record) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $contentHelper = new Moto\Website\PageSectionContent($record); $record->content = $contentHelper->toTemplate(Moto\Features::isEnabled('dev_warm_up_on_template')); $table->update($record); $record->getRelativeUrl(); return $record; } public static function warmUpContent($id) { $id = (integer) $id; $table = new PagesTable(); $table->useResultAsModel(true); $record = $table->getById($id); if (!$record) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $contentHelper = new Moto\Website\PageSectionContent($record); $contentHelper->warmUpContent(); return true; } } 