<?php
 namespace Moto\Application\Presets; use Moto\Json\Request; use Moto\Json\Server; use Moto\Json\Response; use Moto\Application\Presets\InputFilter; use Moto; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'presets'; protected static $_resourcePrivilegesMap = array( 'getList' => 'get', 'getById' => 'get', 'save' => 'set', 'delete' => 'set', 'makeSystem' => 'set', ); public static function getList($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\GetList(); $filter->setData($request); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $request = $filter->getValues(); $query = Moto\Database\Models\Preset::query(); if (!empty($request['widget_name'])) { $query->where('widget_name', $request['widget_name']); } $items = $query ->orderBy('is_system', 'desc') ->orderBy('id') ->get(); $response = new Moto\Json\Response\Collection(); $response->meta->exchangeArray(array( 'total' => $items->count(), 'page' => 1, )); $response->records = $items->toArray(); return $response; } public function getById($id) { $item = Moto\Database\Models\Preset::find((int) $id); if (!$item) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } return $item; } public static function save($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $isNew = false; if (empty($request['id'])) { $isNew = true; } $filter = ($isNew ? new InputFilter\Create() : new InputFilter\Update()); $filter->setData($request); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); if ($isNew) { $preset = new Moto\Database\Models\Preset(); } else { $preset = Moto\Database\Models\Preset::findOrFail((int) $values['id']); } $preset->fill($values); $preset->save(); Moto\System\Style::rebuildAll(); return $preset; } public static function delete($id) { $id = (int) $id; $model = Moto\Database\Models\Preset::findOrFail($id); if ($model->is_system) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_PERMISSION_DENIED_MESSAGE, Moto\System\Exception::ERROR_PERMISSION_DENIED_CODE, array('reason' => 'SYSTEM')); } if ($model->provider === 'default') { throw new Moto\System\Exception(Moto\System\Exception::ERROR_PERMISSION_DENIED_MESSAGE, Moto\System\Exception::ERROR_PERMISSION_DENIED_CODE, array('reason' => 'DEFAULT_PROVIDER')); } if (!$model->delete()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_PERMISSION_DENIED_MESSAGE, Moto\System\Exception::ERROR_PERMISSION_DENIED_CODE, array('reason' => 'NOT_DELETED')); } Moto\System\Style::rebuildAll(); return true; } public static function makeSystem($id) { $id = (int) $id; $model = Moto\Database\Models\Preset::findOrFail($id); $model->is_system = true; $model->save(); return $model; } } 