<?php
namespace Moto\Application\Profile; use Moto\InputFilter\AbstractInputFilter; use Zend\InputFilter\Exception; use Zend\InputFilter\InputFilterInterface; use Moto; class SaveProfileFilter extends AbstractInputFilter { protected $_name = 'profile.save'; public function init() { $this->add(array( 'name' => 'name', 'required' => false, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 100, ), ), ), )); $this->add(array( 'name' => 'language_id', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'Digits', 'break_chain_on_failure' => true, ), array( 'name' => 'Db\RecordExists', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'languages', 'field' => 'id', 'adapter' => Moto\Config::get('databaseAdapter') ) ) ), )); $this->add(array( 'name' => 'email', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'EmailAddress', 'options' => array( 'useMxCheck' => false, 'useDeepMxCheck' => false, 'useDomainCheck' => false, ), ), ), )); } protected function _addElementEmail($currentUserId = 0) { $this->remove('email'); $this->add(array( 'name' => 'email', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'EmailAddress', 'options' => array( 'useMxCheck' => false, 'useDeepMxCheck' => false, 'useDomainCheck' => false, ), ), array( 'name' => 'Db_NoRecordExists', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'users', 'field' => 'email', 'adapter' => Moto\Config::get('databaseAdapter'), 'exclude' => array( 'field' => 'id', 'value' => (int)$currentUserId, ) ) ) ), )); } public function setData($data) { if (!empty($data['id'])) { $this->_addElementEmail($data['id']); } $result = parent::setData($data); return $result; } }