<?php
namespace Moto\Application\RobotsTxt; use Moto\Application\Util; use Moto\Json\Request; use Moto\Json\Response; use Moto\Json\Server; use Moto; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'RobotsTxt'; protected static $_resourcePrivilegesMap = array( 'getSettings' => 'get', 'saveSettings' => 'set', 'getInfo' => 'get', 'getPreview' => 'get', 'generateFile' => 'set', ); public static function getSettings() { return Moto\Website\RobotsTxtService::getSettings(); } public static function saveSettings($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\SaveSettings(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); Moto\Website\RobotsTxtService::saveSettings($values); return $values; } public static function getInfo() { $relativeUrl = Moto\System::getRelativeUrl(); return array( 'file' => Moto\Website\RobotsTxtService::getPrimaryFileInformation(), 'settings' => static::getSettings(), 'environment' => [ 'relativeUrl' => $relativeUrl, 'inRootDirectory' => $relativeUrl === '/', 'inSubDirectory' => $relativeUrl !== '/', ], ); } public static function getPreview($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\SaveSettings(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } return Moto\Website\RobotsTxtService::generateFileContent($filter->getValues()); } public static function generateFile($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $confirmed = Moto\Util::getValue($request, 'confirmed'); if (!$confirmed && Moto\Website\RobotsTxtService::isPrimaryFileExists()) { throw new Server\Exception(Moto\System\Exception::ERROR_NEED_CONFIRMATION, Moto\System\Exception::ERROR_CONFLICT_CODE); } Moto\Website\RobotsTxtService::generateFile(); return static::getInfo(); } } 