<?php
namespace Moto\Application\ServerTest\Validator; use Moto; class Requirements { const CHECK_EMAIL_TIMEOUT = 86400; public $isValid; protected $_validators = array(); protected $_errors = array(); protected function _separatorToCamelCase($subject, $separator = '_') { $separator = preg_quote($separator, '\\'); $parts = explode($separator, strtolower($subject)); $parts = array_map('ucfirst', $parts); return implode($parts); } protected function _phpIniSizeToInt($size) { preg_match('/^([0-9]+)\s*(P|T|G|M|K){0,1}/i', $size, $matches); $value = isset($matches[1]) ? (int) $matches[1] : 0; $unit = isset($matches[2]) ? strtoupper($matches[2]) : ''; switch($unit) { case 'P': $value *= 1024; case 'T': $value *= 1024; case 'G': $value *= 1024; case 'M': $value *= 1024; case 'K': $value *= 1024; break; } return $value; } public function isValid() { $this->isValid = true; foreach ($this->_validators as $validator) { list($validator, $params) = $validator; $validatorFunction = 'validate' . $this->_separatorToCamelCase($validator); if (!method_exists($this, $validatorFunction)) { throw new \Exception('Call to undefined validator "'.$validatorFunction.'"'); } $result = call_user_func(array(&$this, $validatorFunction), $params); $this->isValid = $this->isValid && $result['is_valid']; if (!isset($result['level'])) { $result['level'] = 'error'; } if (!$result['is_valid']) { if (isset($result['error'])) { $name = $result['error']; } else { $name = $validator; } unset($result['is_valid']); unset($result['validator']); unset($result['error']); if ($validator == 'file_writable' || $validator == 'file_readable') { if (!empty($params['type']) && $params['type'] == 'folder') { $name = str_replace('file_', 'folder_', $name); } } $name = strtoupper($name); $this->_errors[] = array( 'name' => $name, 'params' => $result ); } } return $this->isValid; } public function validatePhpVersion($params) { $min = isset($params['min']) ? $params['min'] : 0; $max = isset($params['max']) ? $params['max'] : 0; $params['is_valid'] = true; $params['php_version'] = PHP_VERSION; $phpVersion = PHP_VERSION; if (preg_match('/^(?<version>[\d.]+\d)/', $phpVersion, $match)) { $phpVersion = $match['version']; } if ($min > 0) { $params['is_valid'] = $params['is_valid'] && version_compare($phpVersion, $min, '>='); } if ($max > 0) { $params['is_valid'] = $params['is_valid'] && version_compare($phpVersion, $max, '<='); } return $params; } public function validateFileWritable($params) { $params['is_valid'] = true; if (strtoupper($params['type']) == 'FOLDER') { if ( !is_dir(WEBSITE_DIR . '/' . $params["name"]) ) { if (!isset($params['required']) || $params['required']) { $params['is_valid'] = false; return $params; } } else { $params['is_valid'] = is_writable(WEBSITE_DIR . '/' . $params['name']); } } elseif (strtoupper($params['type']) == 'FILE') { if ( !is_file(WEBSITE_DIR . '/' . $params["name"]) ) { if (!isset($params['required']) || $params['required']) { $params['is_valid'] = false; return $params; } } else { $params['is_valid'] = is_writable(WEBSITE_DIR . '/' . $params['name']); } } else { $params['is_valid'] = is_writable(WEBSITE_DIR . '/' . $params['name']); } return $params; } public function validateFileReadable($params) { $params['is_valid'] = true; if (strtoupper($params['type']) == 'FOLDER') { if ( !is_dir(WEBSITE_DIR . '/' . $params["name"]) ) { if (!isset($params['required']) || $params['required']) { $params['is_valid'] = false; return $params; } } else { $params['is_valid'] = is_readable(WEBSITE_DIR . '/' . $params['name']); } } elseif (strtoupper($params['type']) == 'FILE') { if ( !is_file(WEBSITE_DIR . '/' . $params["name"]) ) { if (!isset($params['required']) || $params['required']) { $params['is_valid'] = false; return $params; } } else { $params['is_valid'] = is_readable(WEBSITE_DIR . '/' . $params['name']); } } else { $params['is_valid'] = is_readable(WEBSITE_DIR . '/' . $params['name']); } return $params; } public function validatePhpExtensionLoaded($params) { $params['is_valid'] = extension_loaded($params['extension']); return $params; } public function validatePhpFunctionExists($params) { $params['is_valid'] = function_exists($params['function']); if (!$params['is_valid']) { $params['error'] = 'php_function_not_exists'; } return $params; } public function validatePhpUploadEnabled($params) { $params['is_valid'] = false; if (ini_get('file_uploads')) { $params['is_valid'] = true; } return $params; } public function validatePhpSessionCreate($params) { $params["is_valid"] = true; if (!function_exists('session_start') || !function_exists('session_name') ) { $params["is_valid"] = false; return $params; } session_start(); if(!isset($params["test_key"])) $params["test_key"]="Test_session_key_" . time(); if(!isset($params["test_value"])) $params["test_value"]="Test_session_value_" . time(); $_SESSION[$params["test_key"]]=$params["test_value"]; session_write_close(); $_SESSION=array(); session_start(); if (!isset($_SESSION[$params["test_key"]])) $params["is_valid"] = false; else unset($_SESSION[$params["test_key"]]); session_write_close(); return $params; } public function validatePhpSafeMode($params) { $safe_mode = ini_get('safe_mode'); $params['is_valid'] = !( $safe_mode == true || strtolower($safe_mode) == 'on' ); return $params; } public function validateMailFunction($params) { if (isset($_SESSION["MOTO_" . __CLASS__][__FUNCTION__]["lastcheck"]) && isset($_SESSION["MOTO_" . __CLASS__][__FUNCTION__]["result"]) && $_SESSION["MOTO_" . __CLASS__][__FUNCTION__]["result"] && is_numeric($_SESSION["MOTO_" . __CLASS__][__FUNCTION__]["lastcheck"]) && (time() - $_SESSION["MOTO_" . __CLASS__][__FUNCTION__]["lastcheck"]) < self::CHECK_EMAIL_TIMEOUT ) { $mail_result = $_SESSION["MOTO_" . __CLASS__][__FUNCTION__]["result"]; } else { $params['is_valid'] = false; $to = 'noreply@cms-guide.com'; $subject = 'mail test'; $message = ''; $headers = 'From: noreply@cms-guide.com' . "\r\n" . 'X-Mailer: PHP/' . phpversion(); try { $mail_result = mail($to, $subject, $message, $headers); $_SESSION["MOTO_" . __CLASS__][__FUNCTION__]["lastcheck"] = time(); $_SESSION["MOTO_" . __CLASS__][__FUNCTION__]["result"] = $mail_result; } catch (Exception $e) {} } if ($mail_result === true) $params['is_valid'] = true; return $params; } public function validatePhpUploadFileSize($params) { $min = isset($params['min']) ? $this->_phpIniSizeToInt($params['min']) : 0; $max = isset($params['max']) ? $this->_phpIniSizeToInt($params['max']) : 0; $uploadMaxSize = min( $this->_phpIniSizeToInt(ini_get('post_max_size')), $this->_phpIniSizeToInt(ini_get('upload_max_filesize')) ); $params['is_valid'] = true; $params['post_max_size'] = ini_get('post_max_size'); $params['upload_max_filesize'] = ini_get('upload_max_filesize'); $params['upload_max_size'] = round($uploadMaxSize / (1024 * 1024), 2) . 'MB'; if ($min > 0) { $params['is_valid'] = $params['is_valid'] && ($uploadMaxSize >= $min); } if ($max > 0) { $params['is_valid'] = $params['is_valid'] && ($uploadMaxSize <= $max); } return $params; } public function validateDiskFreeSpace($params) { if (Moto\Util::isFunctionDisabled('disk_free_space')) { $freeSpace = false; } else { $freeSpace = @disk_free_space(Moto\System::getAbsolutePath('@website')); } $enoughSpace = isset($params['enough_space']) ? $params['enough_space'] : Moto\Config::get('serverRequirements.enough_disk_space'); $enoughSpace = $this->_phpIniSizeToInt($enoughSpace); $params['free_space'] = $freeSpace; $params['enough_space'] = $enoughSpace; $params['is_valid'] = ($freeSpace === false ? true : ($freeSpace > $enoughSpace) ); return $params; } public function addValidator($name, $params = array()) { $this->_validators[] = array($name, $params); return $this; } public function getErrors() { return $this->_errors; } } 