<?php
namespace Moto\Application\Settings; use Moto\InputFilter\AbstractInputFilter; use Moto; class SaveWebsiteSettingsFilter extends AbstractInputFilter { protected $_name = 'settingsWebsite.save'; protected $_enabledInputs; protected function _isEnabledInput($name) { if ($this->_enabledInputs === null) { $this->_enabledInputs = $this->getOption('enableInputs', true); } if (is_array($this->_enabledInputs)) { return in_array($name, $this->_enabledInputs); } return (boolean) $this->_enabledInputs; } public function init() { if ($this->_isEnabledInput('title')) { $this->add(array( 'name' => 'title', 'required' => false, 'allow_empty' => false, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'NotEmpty', 'break_chain_on_failure' => true ), array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 200, ), ), ), )); } if ($this->_isEnabledInput('address')) { $this->add(array( 'name' => 'address', 'required' => false, 'allow_empty' => false, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), array( 'name' => 'Moto\Filter\UriNormalize', 'options' => array( 'removeFragment' => true ) ), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 200, ), 'break_chain_on_failure' => true ), array( 'name' => 'Uri', 'options' => array( 'allowAbsolute' => true, 'allowRelative' => false, ), ) ), )); } if ($this->_isEnabledInput('main_page')) { $this->add(array( 'name' => 'main_page', 'allow_empty' => false, 'required' => true, 'validators' => array( [ 'name' => 'Digits', 'break_chain_on_failure' => true ], [ 'name' => 'Db\RecordExists', 'options' => [ 'table' => Moto\Config::get('database.prefix') . 'pages', 'field' => 'id', 'adapter' => Moto\Config::get('databaseAdapter') ] ] ), )); } if ($this->_isEnabledInput('home_page_provider')) { $sub = new AbstractInputFilter(); $this->add($sub, 'home_page_provider'); $sub->add(array( 'name' => 'name', 'required' => true, 'filters' => array( array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 64, ), ), ), )); } if ($this->_isEnabledInput('language_id')) { $this->add(array( 'name' => 'language_id', 'allow_empty' => false, 'required' => false, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), array('name' => Moto\Filter\IntValue::class), ), 'validators' => array( array( 'name' => 'Digits', 'break_chain_on_failure' => true ), array( 'name' => 'Db\RecordExists', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'languages', 'field' => 'id', 'adapter' => Moto\Config::get('databaseAdapter') ) ) ), )); } if ($this->_isEnabledInput('title_format')) { $this->add(array( 'name' => 'title_format', 'allow_empty' => false, 'required' => false, 'filters' => array( array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'InArray', 'options' => array( 'haystack' => array('{{page.title}}', '{{page.title}} | {{website.title}}', '{{page.title}} - {{website.title}}') ) ), ), )); } if ($this->_isEnabledInput('favicon')) { $this->add(array( 'name' => 'favicon', 'allow_empty' => true, 'required' => false, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 1024, ), ), ), )); } if ($this->_isEnabledInput('back_to_top_button')) { $sub = new AbstractInputFilter(); $this->add($sub, 'back_to_top_button'); $sub->add(array( 'name' => 'topOffset', 'required' => true, 'filters' => array( array('name' => 'Moto\Filter\IntValue'), ), )); $sub->add(array( 'name' => 'animationTime', 'required' => true, 'filters' => array( array('name' => 'Moto\Filter\IntValue'), ), )); $sub->add(array( 'name' => 'type', 'required' => true, 'filters' => array( array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'InArray', 'options' => array( 'haystack' => array('none', 'theme', 'custom') ) ), ), )); } if ($this->_isEnabledInput('password_protection')) { $sub = new AbstractInputFilter(); $this->add($sub, 'password_protection'); $sub->add(array( 'name' => 'enabled', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'Moto\Filter\IntValue'), array('name' => 'Boolean'), ), )); $sub->add(array( 'name' => 'cookie_lifetime', 'required' => true, 'filters' => array( array('name' => 'Moto\Filter\IntValue'), ), )); $sub->add(array( 'name' => 'password', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 1024, ), ), ), )); } if ($this->_isEnabledInput('google_analytics')) { $sub = new AbstractInputFilter(); $this->add($sub, 'google_analytics'); $sub->add(array( 'name' => 'id', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 64, ), ), ), )); $options = new AbstractInputFilter(); $sub->add($options, 'options'); $options->add(array( 'name' => 'anonymize_ip', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'Moto\Filter\IntValue'), array('name' => 'Boolean'), ), 'validators' => array( array( 'name' => 'InArray', 'options' => array( 'haystack' => array(false, true) ) ), ), )); } if ($this->_isEnabledInput('google_webmaster_tools_tag')) { $this->add(array( 'name' => 'google_webmaster_tools_tag', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 1024, ), ), ), )); } if ($this->_isEnabledInput('google_tag_manager')) { $sub = new AbstractInputFilter(); $this->add($sub, 'google_tag_manager'); $sub->add(array( 'name' => 'id', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 64, ), ), ), )); } if ($this->_isEnabledInput('facebook_pixel')) { $sub = new AbstractInputFilter(); $this->add($sub, 'facebook_pixel'); $sub->add(array( 'name' => 'id', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 64, ), ), ), )); } if ($this->_isEnabledInput('yandex_metrica_counter')) { $sub = new AbstractInputFilter(); $this->add($sub, 'yandex_metrica_counter'); $sub->add(array( 'name' => 'id', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 64, ), ), ), )); $sub->add(array( 'name' => 'webvisor', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'Moto\Filter\IntValue'), array('name' => 'Boolean'), ), 'validators' => array( array( 'name' => 'InArray', 'options' => array( 'haystack' => array(false, true) ) ), ), )); $sub->add(array( 'name' => 'track_hash', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'Moto\Filter\IntValue'), array('name' => 'Boolean'), ), 'validators' => array( array( 'name' => 'InArray', 'options' => array( 'haystack' => array(false, true) ) ), ), )); } if ($this->_isEnabledInput('yandex_webmaster_code')) { $this->add(array( 'name' => 'yandex_webmaster_code', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 1024, ), ), ), )); } } } 