<?php
 namespace Moto\Application\Settings; use Moto\Application\Util; use Moto\Json\Request; use Moto\Json\Response; use Moto\Json\Server; use Moto; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'settings'; protected static $_namespaceSeparator = '.'; protected static $_resourcePrivilegesMap = array( 'getWebsiteSettings' => 'get', 'setWebsiteSettings' => 'set', 'getList' => 'get', 'getCodeInjections' => 'get', 'setCodeInjections' => 'set', 'getRedirection' => 'get', 'setRedirection' => 'set', 'getDefaultMailOptions' => 'get', 'setDefaultMailOptions' => 'set', 'getSeoOptions' => 'get', 'setSeoOptions' => 'set', 'getTimezoneList' => 'get', 'getAdvancedSettings' => 'get', 'setAdvancedSettings' => 'set', 'getLiveChatSettings' => 'get', 'setLiveChatSettings' => 'set', 'getFeedbackSettings' => 'get', 'setFeedbackSettings' => 'set', 'enableMaintenanceMode' => 'set', 'disableMaintenanceMode' => 'set', ); public static function enableMaintenanceMode() { return Moto\Website\MaintenanceMode::turnOn(); } public static function disableMaintenanceMode() { return Moto\Website\MaintenanceMode::turnOff(); } public static function getWebsiteSettings($settings = null) { if (!is_array($settings)) { return null; } $settings = Moto\Website\Settings::getOnly($settings); return [ 'settingsControls' => Moto\Website\SettingsProvider::getInstance()->getSettingsControls(array_keys($settings)), 'settingsValues' => $settings, ]; } public static function getList() { $table = new SettingsTable(); $settings = $table->getSettingsList(); if (!$settings) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } return static::toArray($settings); } public static function toArray($settings) { $output = array(); foreach ($settings as $index => $settingsRecord) { if (is_object($settingsRecord)) { if (method_exists($settingsRecord, 'toArray')) { $settingsRecord = $settingsRecord->toArray(); } elseif ($settingsRecord instanceof \ArrayObject) { $settingsRecord = $settingsRecord->getArrayCopy(); } elseif ($settingsRecord instanceof \Zend\Db\ResultSet\ResultSet) { $settingsRecord = $settingsRecord->toArray(); } else { $settingsRecord = json_decode(json_encode($settingsRecord), true); } } if (!array_key_exists('name', $settingsRecord) || !array_key_exists('value', $settingsRecord)) { throw new \UnexpectedValueException('Broken array signature'); } $output = array_merge_recursive($output, static::_explodeNamespace($settingsRecord['name'], $settingsRecord['value'])); } return $output; } protected static function _explodeNamespace($key, $value = '') { $separator = static::$_namespaceSeparator; $parts = explode($separator, $key); $output = array(); $key = array_shift($parts); $output[$key] = sizeof($parts) > 0 ? static::_explodeNamespace(implode($separator, $parts), $value) : $value; return $output; } public static function get($name) { $neededKey = trim($name); $separator = static::$_namespaceSeparator; $table = new SettingsTable(); $settingsList = $table->getSettingsValue(trim($neededKey)); if (!$settingsList->count()) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $found = array(); foreach ($settingsList as $settingsRecord) { $foundKey = $settingsRecord['name']; if ($neededKey === $foundKey || strpos($foundKey, $neededKey . $separator) !== false) { $found = array_merge_recursive($found, static::_explodeNamespace($foundKey, $settingsRecord['value'])); } } if (empty($found)) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $parts = explode($separator, $neededKey); $result = $found; while (!empty($parts)) { $result = $result[array_shift($parts)]; } return $result; } public static function save($data = null) { if (null === $data) { $data = static::getRequest()->getParams(); } try { if (isset($data['website']['back_to_top_button']) && is_array($data['website']['back_to_top_button'])) { $data['website']['back_to_top_button'] = json_encode($data['website']['back_to_top_button']); } if (isset($data['website']['yandex_metrica_counter']) && !is_string($data['website']['yandex_metrica_counter'])) { $data['website']['yandex_metrica_counter'] = json_encode($data['website']['yandex_metrica_counter']); } $settings = static::toNamespaces($data); } catch (\Exception $ex) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $ex->getMessage()); } $settingsTable = new SettingsTable(); if (!$settingsTable->checkIfNamespacesExist(array_keys($settings))) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE, 'Namespace doesn\'t exist'); } $section = 'website'; if (array_key_exists($section, $data)) { $filter = new SaveWebsiteSettingsFilter([ 'enableInputs' => array_keys($data[$section]), ]); $filter->setData($data[$section]); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); foreach ($values as $key => $value) { if (!is_null($value)) { if ($key === 'language_id') { $key = $section . static::$_namespaceSeparator . 'language_'; $settings[$key . 'id'] = $value; $languageRecord = Moto\Database\Models\Language::find($value); if (!$languageRecord) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE); } $settings[$key . 'code'] = $languageRecord['code']; if (!empty($languageRecord['locale'])) { $settings[$key . 'locale'] = $languageRecord['locale']; } continue; } $settings[$section . static::$_namespaceSeparator . $key] = $value; } if ($key === 'maintenance_mode') { Moto\Website\MaintenanceMode::updateCustomPage($value); } } } $settingsTable->savePack($settings); $result = static::toArray($settingsTable->getSettingsList()); return $result; } public static function setWebsiteSettings($data = null) { $settings = static::getRequest()->getParams(); $settingsKeys = array_keys($settings); $errors = []; foreach ($settingsKeys as $key) { if (!Moto\Website\Settings::isExists($key)) { $errors[$key] = ['noRecordFound']; } } if (count($errors) > 0) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE, $errors); } $filter = Moto\Website\SettingsProvider::getInstance()->getInputFilter($settingsKeys); $filter->setData($settings); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); $settings = []; foreach ($values as $key => $value) { if ($key === 'language_code' || $key === 'language_locale') { continue; } if ($key === 'maintenance_mode') { Moto\Website\MaintenanceMode::updateCustomPage($value); } elseif ($key === 'language_id') { $languageRecord = Moto\Database\Models\Language::find($value); if (!$languageRecord) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE); } $settings['language_code'] = $languageRecord['code']; if (!empty($languageRecord['locale'])) { $settings['language_locale'] = $languageRecord['locale']; } } $settings[$key] = $value; } Moto\Website\Settings::bulkSet($settings); Moto\Hook::trigger(Moto\Hook::DATABASE_SETTINGS_UPDATED); Moto\System\Style::rebuildAll(); return Moto\Website\Settings::getOnly($settingsKeys); } public static function toNamespaces(array $settings) { $separator = static::$_namespaceSeparator; $output = array(); foreach ($settings as $namespace => $data) { foreach ($data as $key => $value) { $output[$namespace . $separator . $key] = $value; } } return $output; } public static function getCodeInjections() { return array( 'header' => Moto\Website\Settings::get('custom_code_header', ''), 'footer' => Moto\Website\Settings::get('custom_code_footer', ''), 'execution' => Moto\Website\Settings::get('custom_code_execution', true), 'widget_embed_execution' => Moto\Website\Settings::get('widget_embed_execution', true), ); } public static function setCodeInjections($request = null) { if (null === $request) $request = static::getRequest()->getParams(); $filter = new InputFilter\CodeInjection(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); Moto\Website\Settings::set('custom_code_header', $values['header']); Moto\Website\Settings::set('custom_code_footer', $values['footer']); Moto\Website\Settings::set('custom_code_execution', $values['execution']); Moto\Website\Settings::set('widget_embed_execution', $values['widget_embed_execution']); return static::getCodeInjections(); } public static function getDefaultMailOptions() { return Moto\Website\Settings::get('default_mail_options'); } public static function setDefaultMailOptions($request = null) { if (null === $request) $request = static::getRequest()->getParams(); $filter = new InputFilter\MailOptions(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); Moto\Website\Settings::set('default_mail_options', $values); return $values; } public static function setIntegrationValue($request = null) { if (null === $request) $request = static::getRequest()->getParams(); $filter = new InputFilter\IntegrationValue(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $model = Moto\Website\Integration::first($values['type']); $model->fromArray($values['items'][0]); $model->save(); return $model->toArray(); } public static function setSystemEngine($request = null) { if (null === $request) $request = static::getRequest()->getParams(); $filter = new InputFilter\SystemEngineData(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $engine = Moto\System\Settings::getEngine(); $value = $filter->getValue('value'); return $engine->updateSystemEngineData($value); } public static function getRedirection() { return array( 'rules' => Moto\Website\Settings::get('redirection_rules', array()), ); } public static function setRedirection($rules = null) { if (null === $rules) { $rules = static::getRequest()->getParam('rules'); } Moto\Website\Settings::set('redirection_rules', $rules); return static::getRedirection(); } public static function getTimezoneList() { $failedDependency = Moto\Application\Util\Timezones::getFailedDependency(); if ($failedDependency) { throw new Server\Exception(Moto\System\Exception::ERROR_FAILED_DEPENDENCY_MESSAGE, Moto\System\Exception::ERROR_FAILED_DEPENDENCY_CODE, array('dependency' => $failedDependency)); } $records = Moto\Application\Util\Timezones::getList(); return [ 'meta' => array( 'total' => count($records), 'limit' => 0, 'page' => 0, ), 'records' => $records ]; } public static function getSeoOptions() { return array( 'website' => array( 'suffix' => (boolean) (int) Moto\Website\Settings::get('suffix'), 'permalinks' => (boolean) (int) Moto\Website\Settings::get('permalinks'), 'seo_html_attribute_lang' => Moto\Website\Settings::get('seo_html_attribute_lang'), 'open_graph_settings' => Moto\Website\Settings::get('open_graph_settings', (object) [ 'default' => false, ]), ), 'sitemap' => Moto\Application\Sitemap\Service::getInfo(), 'robotsTxt' => Moto\Application\RobotsTxt\Service::getInfo(), ); } public static function setSeoOptions($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\SeoOptions(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $websiteSettings = (array) Moto\Util::getValue($values, 'website'); if (is_array($websiteSettings)) { $settingsTable = new SettingsTable(); foreach ($websiteSettings as $key => $settingsValue) { if (is_array($settingsValue) || is_object($settingsValue)) { $settingsValue = json_encode($settingsValue); } if (is_bool($settingsValue)) { $settingsValue = (int) $settingsValue; } $settingsTable->update(array('value' => $settingsValue), array('name' => 'website.' . $key)); } Moto\Hook::trigger(Moto\Hook::DATABASE_SETTINGS_UPDATED); } Moto\Website\SitemapService::saveSettings(Moto\Util::getValue($values, 'sitemap')); if (Moto\Util::arrayHas($request, 'robotsTxt')) { Moto\Website\RobotsTxtService::saveSettings($values['robotsTxt']); } return static::getSeoOptions(); } public static function getAdvancedSettings() { return array( 'timezone' => Moto\Website\Settings::get('timezone'), 'under_construction' => Moto\Website\Settings::get('under_construction'), 'maintenance_mode' => Moto\Website\Settings::get('maintenance_mode'), 'lazy_loading' => Moto\Website\Settings::get('lazy_loading'), 'popup_preferences' => Moto\Website\Settings::get('popup_preferences'), 'cookie_notification' => Moto\Website\Settings::get('cookie_notification'), 'control_panel_analytics' => Moto\Website\Settings::get('control_panel_analytics'), ); } public static function setAdvancedSettings($data = null) { if (null === $data) { $data = static::getRequest()->getParams(); } $filter = new InputFilter\AdvancedSettings([ 'enableInputs' => array_keys($data), ]); $filter->setData($data); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); foreach ($values as $key => $value) { if (is_null($value)) { continue; } if ($key === 'cookie_notification') { $value['content_hash'] = md5($value['content'] . Moto\Util::getValue($value, 'controls.accept.label', '')); } if ($key === 'maintenance_mode') { Moto\Website\MaintenanceMode::updateCustomPage($value); } Moto\Website\Settings::set($key, $value); } Moto\Hook::trigger(Moto\Hook::DATABASE_SETTINGS_UPDATED); return static::getAdvancedSettings(); } protected static function getLiveChatManager() { return Moto\System::app('System.Integration.LiveChat'); } public static function getLiveChatSettings() { return static::getLiveChatManager()->exportEnvironment(); } public static function setLiveChatSettings($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } if (!array_key_exists('name', $request)) { $request = [ 'name' => $request['provider'], 'properties' => Moto\Util::getValue($request, 'providers.' . Moto\Util::getValue($request, 'provider')), 'activate' => true, ]; } $filter = new Moto\Application\Settings\InputFilter\LiveChatSettings(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $request = $filter->getValues(true); $manager = static::getLiveChatManager(); $provider = $manager->getProvider($request['name']); $filter = $provider->getInputFilter(); $filter->setData($request['properties']); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, [ 'properties' => $filter->getMessagesKeys(), ] ); } $provider->setProperties($filter->getValues(true)); if (array_key_exists('activate', $request) && $request['activate']) { $manager->deactivate(); $manager->activate($provider); } $manager->saveConfiguration(); return static::getLiveChatSettings(); } public static function getFeedbackSettings() { return Moto\Website\Settings::get('integration_feedback'); } public static function setFeedbackSettings($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new InputFilter\FeedbackSettings(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); Moto\Website\Settings::add('integration_feedback', $values, 'object'); return static::getFeedbackSettings(); } } 