<?php
namespace Moto\Application\Settings; use Moto; use Moto\Application\Model\AbstractTable; use Zend\Db\Sql; use Zend\Db\Sql\Select; class SettingsTable extends AbstractTable { protected $table = 'settings'; protected $_resultModel = 'Moto\Application\Settings\SettingsModel'; protected $_primaryKey = 'id'; public function getSettingsValue($name) { $select = new Select(); $select->from($this->table); $where = new Sql\Where(); $where->like('name', $name . '.%'); $select->where($where); return $this->executeSelect($select); } public function getSettingsList() { return $this->select(); } public function checkIfNamespacesExist(array $namespaces) { $select = new Select(); $select->from($this->table); $where = new Sql\Where(); $where->in('name', $namespaces); $select->where($where); $existingNamespaces = $this->executeSelect($select); return $existingNamespaces->count() === count($namespaces); } public function savePack($settings) { $saved = false; foreach ($settings as $key => $settingsValue) { if (is_array($settingsValue) || is_object($settingsValue)) { $settingsValue = json_encode($settingsValue); } if (is_bool($settingsValue)) { $settingsValue = (int) $settingsValue; } $saved = $this->update(array('value' => $settingsValue), array('name' => $key)) || $saved; } Moto\Hook::trigger(Moto\Hook::DATABASE_SETTINGS_UPDATED); Moto\System\Style::rebuildAll(); return $saved; } public function getByName($name) { $row = null; $select = new Select($this->table); $select->where(array( 'name' => $name )); $resultSet = $this->executeSelect($select); if ($resultSet->count()) { $row = $resultSet->current(); } return $row; } }