<?php
namespace Moto\Application\Util; use Zend\Mail; use Zend\Mime; use Zend\Mail\Transport\File as FileTransport; use Zend\Mail\Transport\FileOptions; use Zend\Mail\Transport\Sendmail as SendmailTransport; use Zend\Mail\Transport\Smtp as SmtpTransport; use Zend\Mail\Transport\SmtpOptions; use Moto; use Zend\Stdlib\ArrayUtils; use Zend\Mail\Transport\TransportInterface; class Mailer { protected static $_options = array(); protected static $_renderEngine = null; protected static $_initialized = false; public static function init() { if (static::$_initialized) { return; } static::$_initialized = true; static::_initDefaultOptions(); } protected static function _initDefaultOptions() { $options = Moto\Config::get('mail'); $defaultOptions = Moto\Website\Settings::get('default_mail_options'); if (is_array($defaultOptions)) { $options['options'] = array_merge($options['options'], $defaultOptions); } static::setOptions($options); } public static function setOptions(array $options) { self::$_options = array_merge(self::$_options, $options); } public static function getOptions() { return self::$_options; } public static function setOption($name, $value) { self::$_options[$name] = $value; } public static function getOption($name, $default = null) { return (array_key_exists($name, self::$_options) ? self::$_options[$name] : $default); } public static function getMailTemplateOptions($mailName) { $globalOptions = self::getOption('options', array()); $options = self::getOption($mailName, array()); $options = ArrayUtils::merge($globalOptions, $options); return $options; } public static function getMailTemplateFilePath($mailName, $fileName, $locale = '') { $dir = Moto\System::getAbsolutePath('@emailTemplates'); $templatePath = $dir . '/' . $fileName; if (!empty($locale) && is_string($locale)) { $ext = pathinfo($fileName, PATHINFO_EXTENSION); $name = pathinfo($fileName, PATHINFO_FILENAME); $templatePathLocale = $dir . '/' . $name . '-' . $locale . '.' . $ext; if (file_exists($templatePathLocale)) { return $templatePathLocale; } } if (!file_exists($templatePath)) { throw new \Exception('Cant find mail template ' . $mailName); } return $templatePath; } public static function sendMailByName($mailName, $mailTo, $data = array(), $locale = '') { if (!self::getOption('enabled')) { return null; } $messageParams = array( 'template' => array( 'subject' => '', 'filePath' => '', 'locale' => $locale, ), 'mailName' => $mailName, 'to' => array( 'email' => $mailTo, ), ); $options = self::getMailTemplateOptions($mailName); if(!empty($options['fromEmail'])) { $messageParams['from']['email'] = $options['fromEmail']; } else { $webmaster = Moto\Website\Settings::getWebmaster(); $messageParams['from']['email'] = $webmaster->email; } $messageParams['template']['subject'] = $options['subject']; $messageParams['subject'] = self::_renderTemplate($messageParams['template']['subject'], $data); $templatePath = self::getMailTemplateFilePath($mailName, $options['template'], $locale); $messageParams['template']['filePath'] = $templatePath; $messageParams['template']['content'] = file_get_contents($templatePath); $messageParams['body'] = self::_renderTemplate($messageParams['template']['content'], $data); if (defined('Moto\Hook::SYSTEM_MAILER__MESSAGE_PARAMS')) { $hookedParams = Moto\Hook::trigger(Moto\Hook::SYSTEM_MAILER__MESSAGE_PARAMS, $messageParams); if (is_array($hookedParams)) { $messageParams = $hookedParams; } } $content = Moto\Util::getValue($messageParams, 'body', ''); $message = new Mail\Message(); $message->setEncoding('UTF-8'); $html = new Mime\Part($content); $html->type = Mime\Mime::TYPE_HTML; $html->charset = 'UTF-8'; $html->disposition = Mime\Mime::DISPOSITION_INLINE; $html->encoding = Mime\Mime::ENCODING_QUOTEDPRINTABLE; $text = new Mime\Part(strip_tags($content)); $text->type = Mime\Mime::TYPE_TEXT; $text->charset = 'UTF-8'; $text->disposition = Mime\Mime::DISPOSITION_INLINE; $text->encoding = Mime\Mime::ENCODING_QUOTEDPRINTABLE; $body = new Mime\Message(); $body->setParts(array($text, $html)); $message->setBody($body); $message->addTo(Moto\Util::getValue($messageParams, 'to.email')); $message->setFrom(Moto\Util::getValue($messageParams, 'from.email'), Moto\Util::getValue($messageParams, 'from.name')); $message->setSubject(Moto\Util::getValue($messageParams, 'subject', '')); $transport = static::_getTransport(Moto\Util::getFromArrayDeep($options, 'transport.class'), Moto\Util::getFromArrayDeep($options, 'transport.parameters')); $message->getHeaders()->get('content-type')->setType('multipart/alternative'); if (defined('Moto\Hook::SYSTEM_MAILER__MESSAGE_SENDING')) { Moto\Hook::trigger(Moto\Hook::SYSTEM_MAILER__MESSAGE_SENDING, $message, $messageParams); } $transport->send($message); return true; } public static function sendMail($messageParams = array()) { $messageParams = Moto\Hook::trigger('SystemMailer: sendMail.params', $messageParams); if (!self::getOption('enabled')) { return false; } $mailName = Moto\Util::getValue($messageParams, 'mailName', 'contactForm'); $messageParams['mailName'] = $mailName; $webmaster = Moto\Website\Settings::getWebmaster(); $options = self::getMailTemplateOptions($mailName); if (empty($messageParams['to']['email'])) { $messageParams['to']['email'] = $webmaster->email; } if (empty($messageParams['from']['email'])) { if (empty($options['fromEmail'])){ $messageParams['from']['email'] = $webmaster->email; } else { $messageParams['from']['email'] = $options['fromEmail']; } } if (defined('Moto\Hook::SYSTEM_MAILER__MESSAGE_PARAMS')) { $hookedParams = Moto\Hook::trigger(Moto\Hook::SYSTEM_MAILER__MESSAGE_PARAMS, $messageParams); if (is_array($hookedParams)) { $messageParams = $hookedParams; } } $content = Moto\Util::getValue($messageParams, 'body', ''); $message = new Mail\Message(); $message->setEncoding('UTF-8'); $html = new Mime\Part($content); $html->type = Mime\Mime::TYPE_HTML; $html->charset = 'UTF-8'; $html->disposition = Mime\Mime::DISPOSITION_INLINE; $html->encoding = Mime\Mime::ENCODING_QUOTEDPRINTABLE; $content = str_replace('<br/>', "\n", $content); $content = strip_tags($content); $text = new Mime\Part($content); $text->type = Mime\Mime::TYPE_TEXT; $text->charset = 'UTF-8'; $text->disposition = Mime\Mime::DISPOSITION_INLINE; $text->encoding = Mime\Mime::ENCODING_QUOTEDPRINTABLE; $contentMessage = new Mime\Message(); $contentMessage->setParts(array($text, $html)); $contentPart = new Mime\Part($contentMessage->generateMessage()); $contentPart->type = Mime\Mime::MULTIPART_ALTERNATIVE; $contentPart->boundary = $contentMessage->getMime()->boundary(); $body = new Mime\Message(); $body->addPart($contentPart); if (!empty($messageParams['attachments']) && is_array($messageParams['attachments'])) { foreach($messageParams['attachments'] as $file) { if (empty($file['path']) || !file_exists($file['path'])) { continue; } $filePath = $file['path']; $fileContent = fopen($filePath, 'r'); $attachment = new Mime\Part($fileContent); if (!empty($file['type'])) { $attachment->type = $file['type']; } if (empty($file['name'])) { $attachment->filename = basename($filePath); } else { $attachment->filename = $file['name']; } $attachment->disposition = Mime\Mime::DISPOSITION_ATTACHMENT; $attachment->encoding = Mime\Mime::ENCODING_BASE64; $body->addPart($attachment); } } $message->setBody($body); $recipient = $messageParams['to']['email']; if (is_string($recipient)) { $recipient = str_replace("\n", ' ', $recipient); $recipient = str_replace(array(' ', ';'), ',', $recipient); $recipient = trim(preg_replace('/([,]+)/', ',', $recipient), ' ,'); $recipient = explode(',', $recipient); } if (is_array($recipient)) { $recipient = array_unique($recipient); } $message->addTo($recipient); $message->setFrom($messageParams['from']['email']); $message->setSubject(Moto\Util::getValue($messageParams, 'subject', '')); $transport = static::_getTransport(Moto\Util::getFromArrayDeep($options, 'transport.class'), Moto\Util::getFromArrayDeep($options, 'transport.parameters')); Moto\Hook::trigger('SystemMailer: sendMail.message', $message); if (defined('Moto\Hook::SYSTEM_MAILER__MESSAGE_SENDING')) { Moto\Hook::trigger(Moto\Hook::SYSTEM_MAILER__MESSAGE_SENDING, $message, $messageParams); } $transport->send($message); return true; } protected static function _getTransport($class, $parameters) { $transport = null; $options = null; if (defined('Moto\Hook::SYSTEM_MAILER__TRANSPORT_PARAMS')) { $options = Moto\Hook::trigger(Moto\Hook::SYSTEM_MAILER__TRANSPORT_PARAMS, array( 'class' => $class, 'parameters' => $parameters, )); } if (!empty($options['class']) && is_string($options['class'])) { $class = $options['class']; if (is_array($options['parameters'])) { $parameters = $options['parameters']; } } switch($class) { case 'File': $path = Moto\Util::getFrom($parameters, 'path'); if (is_string($path)) { $path = trim($path); $path = Moto\System::getAbsolutePath($path); if (!empty($path) && !is_dir($path)) { Moto\Util::createDir($path); } $parameters['path'] = $path; } $transportOptions = new FileOptions($parameters); $transport = new FileTransport($transportOptions); break; case 'Smtp': if (empty($parameters['connection_config']['ssl'])) { unset($parameters['connection_config']['ssl']); } $transportOptions = new SmtpOptions($parameters); $transport = new SmtpTransport($transportOptions); break; case 'Sendmail': $transport = new SendmailTransport(); break; default: break; } if (defined('Moto\Hook::SYSTEM_MAILER__TRANSPORT_CREATED')) { $_transport = Moto\Hook::trigger(Moto\Hook::SYSTEM_MAILER__TRANSPORT_CREATED, $transport, $class, $parameters); if ($_transport instanceof TransportInterface) { $transport = $_transport; } } return $transport; } protected static function _renderTemplate($template, $data = array()) { $engine = self::getRenderEngine(); $out = $engine->render($template, $data); return $out; } public static function getRenderEngine() { if (null == self::$_renderEngine) { self::$_renderEngine = Moto\Render::getInstance('string'); } return self::$_renderEngine; } public static function setRenderEngine($engine) { self::$_renderEngine = $engine; } } 