<?php
namespace Moto\Authentication; use Moto; use Zend\Authentication\AuthenticationService as ZendAuthenticationService; use Zend\Authentication; use Exception; require_once __DIR__ . '/StorageCookie.php'; require_once __DIR__ . '/Adapter.php'; final class AuthenticationService extends ZendAuthenticationService { const ERROR_PRODUCT_IS_NOT_ACTIVATED_MESSAGE = 'ERROR.PRODUCT_IS_NOT_ACTIVATED'; const ERROR_PRODUCT_IS_NOT_ACTIVATED_CODE = 403; protected $_options = array( 'cookieName' => 'moto_auth', 'cookieIsSecure' => false, 'cookieHttpOnly' => true, 'cookieExpire' => '+12 hours', 'expiredDay' => 1, 'tokenDelimiter' => '-', 'rememberMe' => false, ); protected $storage; protected $_authToken; protected $_authTokenExpired = false; protected static $_instance = null; protected $_util = null; public static function getInstance() { if (is_null(self::$_instance)) { self::$_instance = new self(); } return self::$_instance; } protected function _getUtil() { if (null == $this->_util) { $this->_util = new Util($this); } return $this->_util; } public function __construct(Authentication\Storage\StorageInterface $storage = null, Authentication\Adapter\AdapterInterface $adapter = null) { $storage = new StorageCookie($this->_options); parent::__construct($storage, $adapter); $this->initProductInfo(); $this->initUser(); } public function initProductInfo() { if (class_exists('Moto\System\ProductInformation')) { Moto\System\ProductInformation::init(); } if (class_exists('Moto\System\ProductInformation') && Moto\System\ProductInformation::isReady()) { $productId = Moto\System\ProductInformation::getProductId(); } else { $productId = $this->_getUtil()->getProductId(); } Moto\Config::set('__product_id__', $productId); Moto\System::setEncryptMachineKey($productId); } public function initUser($authToken = null) { if (!Moto\System::isInstalled()) { return false; } if (isset($_COOKIE[$this->_options['cookieName']])) { $this->_authToken = $_COOKIE[$this->_options['cookieName']]; } if (empty($authToken)) { $authToken = $this->_authToken; } if (empty($authToken)) { return; } $tokenDelimiter = $this->getOption('tokenDelimiter', '-'); if (preg_match('/^([0-9]+)' . $tokenDelimiter . '([0-9]+)' . $tokenDelimiter . '(.*)$/', $authToken, $match)) { $userId = $match[1]; $expiration = $match[2]; $signature = $match[3]; if ($expiration < time()) { $this->_authTokenExpired = true; return; } $user = Moto\Database\Models\User::find($userId); if ($user) { $tokenSignature = Moto\Authentication\Security::generateCookieTokenSignature($user, $expiration, 'auth'); if ($tokenSignature === $signature && $user->enabled) { unset($user->salt); $this->storage->write($user); } } } } public function setOption($name, $value) { $this->_options[$name] = $value; return $this; } public function getOption($name, $default = null) { return (array_key_exists($name, $this->_options) ? $this->_options[$name] : $default); } public function issetOption($name) { return (array_key_exists($name, $this->_options)); } public function setOptions($options) { if (is_array($options)) $this->_options = array_merge($this->_options, $options); } public function login($credentials = array()) { if (empty($credentials)) { $credentials = Moto\System\Request::getParams(); } $inputFilter = new Moto\Authentication\InputFilter\Login(); $inputFilter->setData($credentials); if (!$inputFilter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $inputFilter->getMessagesKeys()); } $credentials = $inputFilter->getValues(); $this->setRememberMode($credentials['remember']); $authAdapter = new Adapter($credentials['email'], $credentials['password']); $authResult = $this->_authenticate($authAdapter); if ($authResult->isValid()) { $this->sendCookie(); } else { $this->clearIdentity(); throw new Moto\System\Exception(Moto\System\Exception::ERROR_ACCESS_DENIED_MESSAGE, Moto\System\Exception::ERROR_ACCESS_DENIED_CODE); } return $this->getIdentity(); } protected function _authenticate($authAdapter) { $authResult = $this->authenticate($authAdapter); if (!$authResult->isValid()) { return $authResult; } if (class_exists('Moto\System\ProductInformation') && Moto\System\ProductInformation::isReady()) { $productUpdater = new Moto\System\ProductUpdater(); $productUpdater->syncInformation($this->getIdentity()); return $authResult; } throw new Moto\System\Exception( Moto\System\Exception::ERROR_FAILED_DEPENDENCY_MESSAGE, Moto\System\Exception::ERROR_FAILED_DEPENDENCY_CODE, array( 'dependency' => 'Production Information' ) ); } public function syncProductInformation() { $user = $this->getIdentity(); if (!$user) { return array( 'status' => false, 'error' => array( 'code' => 403, 'message' => 'InvalidUser', ) ); } try { $productUpdater = new Moto\System\ProductUpdater(); $productUpdater->syncInformation($user); } catch (\Exception $e) { return array( 'status' => false, 'error' => array( 'code' => $e->getCode(), 'message' => $e->getMessage(), ), ); } return array( 'status' => true ); } public function setRememberMode($flag) { $this->setOption('rememberMe', $flag); } public function updateIdentity($user) { if (!$user instanceof Moto\Database\Models\User) { return null; } $this->getStorage()->write($user); $expiration = null; if (APPLICATION_ENV !== 'testing' && !empty($_COOKIE[$this->_options['cookieName']])) { $tokenInfo = Moto\Authentication\Security::parseToken($this->_authToken); $expiration = $tokenInfo['expiration']; } $value = $this->sendCookie($expiration); return $value; } public function sendCookie($expiration = null) { $cookieName = $this->getOption('cookieName', 'moto_auth'); $cookieExpire = $this->getOption('cookieExpire', '+1 day'); $cookieExpire = strtotime($cookieExpire); $cookiePath = $this->_getCookiePath(); $cookieDomain = $this->_getCookieDomain(); $cookieIsSecure = $this->getOption('cookieIsSecure', false); $cookieHttpOnly = $this->getOption('cookieHttpOnly', true); if (null === $expiration) { $expiration = $cookieExpire; } $user = $this->getIdentity(); $cookieValue = $this->generateCookieValue($user, $expiration, 'auth'); if (null == $cookieValue) return false; if ($this->getOption('rememberMe', false)) { } else { $cookieExpire = 0; } if (APPLICATION_ENV !== 'testing') { setcookie($cookieName, $cookieValue, $cookieExpire, $cookiePath, $cookieDomain, $cookieIsSecure, $cookieHttpOnly); } $_COOKIE[$cookieName] = $cookieValue; return $cookieValue; } public function generateCookieValue($user, $expiration = null, $scheme = 'auth') { if (!is_object($user) || empty($user->id)) { return null; } if (null == $expiration) { $expiration = time() + ($this->getOption('expiredDay', 2) * 60 * 60 * 24); } $tokenDelimiter = $this->getOption('tokenDelimiter', '-'); $tokenSignature = Moto\Authentication\Security::generateCookieTokenSignature($user, $expiration, $scheme); if (null === $tokenSignature) return null; $cookieValue = $user->id . $tokenDelimiter . $expiration . $tokenDelimiter . $tokenSignature; return $cookieValue; } public function clearIdentity() { $this->_authTokenExpired = false; parent::clearIdentity(); $cookieName = $this->getOption('cookieName', 'moto_auth'); $cookiePath = $this->_getCookiePath(); $cookieDomain = $this->_getCookieDomain(); $cookieIsSecure = $this->getOption('cookieIsSecure', false); $cookieHttpOnly = $this->getOption('cookieHttpOnly', true); if (array_key_exists($cookieName, $_COOKIE)) { if (APPLICATION_ENV !== 'testing') { setcookie($cookieName, '', -1, $cookiePath, $cookieDomain, $cookieIsSecure, $cookieHttpOnly); if (!empty($cookieDomain)) { setcookie($cookieName, '', -1, $cookiePath, null, $cookieIsSecure, $cookieHttpOnly); } } unset($_COOKIE[$cookieName]); } return true; } protected function _getCookieDomain() { $domain = $this->getOption('cookieDomain'); if (!empty($domain) && !preg_match('/^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$/', $domain)) { if ($domain[0] !== '.') { $domain = '.' . $domain; } if (strrpos($domain, '.') < 1) { $domain = null; } } return $domain; } protected function _getCookiePath() { $path = ($this->issetOption('cookiePath') ? $this->getOption('cookiePath') : '/'); if (!empty($path)) { $path = trim($path); $path = '/' . ltrim($path, '/'); $path = rtrim($path, '/') . '/'; } return $path; } public function isSessionExpired() { return $this->_authTokenExpired; } } 