<?php
namespace Moto\ClickAction; use Moto; use Zend\Json\Json; use Zend\Stdlib\ArrayUtils; class AbstractClickAction { protected static $_usingPermalinks = true; protected static $_usingHtmlSuffix = false; protected $_data = array(); protected $_defaultData = array(); protected $actionName; protected $_toStringMethod = 'getUrl'; public function __construct($data = array()) { $this->setData($data); $this->_init(); } protected function _init() { } public function setActionName($name) { if ($this->actionName !== null && $this->actionName !== $name) { throw new \Exception('Change action name is not allowed'); } $this->actionName = $name; return $this; } public function getActionName() { return $this->actionName; } public static function setUsingPermalinks($set = true) { self::$_usingPermalinks = (bool)$set; } public static function setUsingHtmlSuffix($set = true) { self::$_usingHtmlSuffix = (bool)$set; } public static function generateAttributes($action, array $options) { return Moto\ClickAction\Factory::create($action, $options)->generateTagAttrs(); } public static function generateAttributesFromLink($link, $default = '') { if (!is_array($link)) { return $default; } return Moto\ClickAction\Factory::create($link)->generateTagAttrs(); } public static function create($action, array $options) { return Moto\ClickAction\Factory::create($action, $options); } public function setData($data) { if (is_array($data)) { $this->_data = ArrayUtils::merge($this->_defaultData, $data); } return $this; } public function getData() { return $this->_data; } public function set($name, $value) { $this->_data[$name] = $value; return $this; } public function get($name, $default = null) { return (array_key_exists($name, $this->_data) ? $this->_data[$name] : $default); } public function has($name) { return array_key_exists($name, $this->_data); } public function generateTagAttrs() { return trim($this->getHrefAttr() . ' ' . $this->getTargetAttr() . ' ' . $this->getRelAttr() . ' ' . $this->getDataActionAttr() . ' ' . $this->getAdditionalAttributes()); } public function getAdditionalAttributes() { return ''; } public function toArray($extra = null) { $properties = $this->_data; if (is_array($properties)) { unset($properties['action']); } $result = array( 'action' => $this->get('action'), ); if (!empty($properties)) { $result['properties'] = $properties; } if (is_string($extra)) { $extra = array($extra); } if (is_array($extra)) { if (in_array('url', $extra)) { $result['url'] = $this->getUrl(); } if (in_array('target', $extra)) { $result['target'] = $this->getTarget(); } } return $result; } public function generate() { if (APPLICATION_ENV === 'development' && class_exists('Moto\System\Log', true)) { $log = "@deprecated : " . get_class($this) . '->' . __FUNCTION__ . "\n"; $tr = debug_backtrace(); foreach($tr as $i => $item) { if ($i > 3 || empty($item['class'])) { break; } $log .= $item['class'] . ':' . Moto\Util::getFrom($item, 'function', 'NONE') . '  ' . Moto\Util::getFrom($item, 'file', 'NONE') . "\n"; } Moto\System\Log::debug($log); } return $this->generateTagAttrs(); } public function getUrl() { $url = $this->get('url', ''); if (empty($url)) { $url = $this->get('fallback', '#'); } return $url; } public function getHref() { return $this->getUrl(); } public function getHrefAttr() { $url = $this->getUrl(); return empty($url) ? '' : 'href="' . $url . '"'; } public function getTarget() { $target = $this->get('target', ''); if ($target == 'self') { $target = '_self'; } return $target; } public function getTargetAttr() { $target = $this->getTarget(); return (empty($target) || $target == '_self') ? '' : 'target="' . $target . '"'; } public function getRel() { $attributes = $this->get('rel', array()); if (!is_array($attributes)) { $attributes = (array) $attributes; } if ($this->get('nofollow')) { $attributes[] = 'nofollow'; } return $attributes; } public function getRelAttr() { $attributes = $this->getRel(); return empty($attributes) ? '' : 'rel="' . implode(' ', $attributes) . '"'; } public function getDataActionAttr() { return 'data-action="' . $this->get('action') . '"'; } public function __call($name, $args) { return null; } public function __toString() { if (is_string($this->_toStringMethod) && method_exists($this, $this->_toStringMethod)) { $method = $this->_toStringMethod; return (string) $this->{$method}(); } return ''; } public function isCurrent($properties, $linker) { return false; } } 