<?php
 namespace Moto\Database; use Illuminate\Contracts\Support\Arrayable; use Moto; use Illuminate; use ArrayObject; class BaseModel extends Illuminate\Database\Eloquent\Model { public function __construct(array $attributes = []) { if (method_exists($this, 'getClassCastableAttributeValue') || method_exists($this, 'resolveCasterClass')) { throw new \Exception('Please upgrade code : You have a new framework version. Remove block <Custom Cast Attributes> in ' . __CLASS__); } parent::__construct($attributes); } public function toArrayExcept($keys = null) { return Moto\Util::arrayExcept($this->toArray(), (array) $keys); } public function toArrayOnly($keys = null) { return Moto\Util::arrayOnly($this->toArray(), (array) $keys); } public function toArrayObject() { return new ArrayObject($this->attributesToArray(), ArrayObject::ARRAY_AS_PROPS); } protected $_classCastCache = []; protected function _getCastableAttributeValue($key, $value = null) { if (isset($this->_classCastCache[$key])) { return $this->_classCastCache[$key]; } if (!$value) { $value = $this->getAttributeFromArray($key); } $caster = $this->_resolveCustomCaster($key); $value = $caster->get($this, $key, $value, $this->attributes); $this->_classCastCache[$key] = $value; return $value; } protected function _setCastableAttributeValue($key, $value) { $caster = $this->_resolveCustomCaster($key); $raw = $caster->set( $this, $key, $value, $this->attributes ); if (is_array($raw)) { $this->attributes = array_merge($this->attributes, $raw); } else { $this->attributes[$key] = $raw; } $this->_classCastCache[$key] = $value; } protected function _mergeAttributesFromClassCasts() { foreach ($this->_classCastCache as $key => $value) { $caster = $this->_resolveCustomCaster($key); $raw = $caster->set($this, $key, $value, $this->attributes); if (is_array($raw)) { $this->attributes = array_merge($this->attributes, $raw); } else { $this->attributes[$key] = $raw; } } } public function setRawAttributes(array $attributes, $sync = false) { $this->_classCastCache = []; parent::setRawAttributes($attributes, $sync); } protected function _isClassCastable($key) { return (array_key_exists($key, $this->casts) && strpos($this->casts[$key], '\\') !== false); } public function getAttribute($key) { if (!$key) { return; } if ($this->_isClassCastable($key)) { return $this->_getCastableAttributeValue($key); } return parent::getAttribute($key); } protected function castAttribute($key, $value) { if ($this->_isClassCastable($key)) { return $this->_getCastableAttributeValue($key); } return parent::castAttribute($key, $value); } public function originalIsEquivalent($key, $current) { if (!$this->_isClassCastable($key)) { return parent::originalIsEquivalent($key, $current); } $original = $this->getOriginal($key); return $original === $current; } protected function addCastAttributesToArray(array $attributes, array $mutatedAttributes) { foreach ($this->_classCastCache as $key => $value) { if ($value instanceof Arrayable) { $value = $value->toArray(); } $attributes[$key] = $value; } return parent::addCastAttributesToArray($attributes, $mutatedAttributes); } protected function _resolveCustomCaster($key) { $castType = $this->casts[$key]; if (is_object($castType)) { return $castType; } $arguments = []; if (is_string($castType) && strpos($castType, ':') !== false) { $segments = explode(':', $castType, 2); $castType = $segments[0]; $arguments = explode(',', $segments[1]); } $caster = new $castType(...$arguments); return $caster; } public function setAttribute($key, $value) { if ($this->_isClassCastable($key)) { return $this->_setCastableAttributeValue($key, $value); } return parent::setAttribute($key, $value); } public function getArrayableAttributes() { $this->_mergeAttributesFromClassCasts(); return parent::getArrayableAttributes(); } public function getAttributes() { $this->_mergeAttributesFromClassCasts(); return parent::getAttributes(); } public function save(array $options = []) { $this->_mergeAttributesFromClassCasts(); return parent::save($options); } public function delete() { $this->_mergeAttributesFromClassCasts(); return parent::delete(); } public function __sleep() { $this->_mergeAttributesFromClassCasts(); $this->_classCastCache = []; return array_keys(get_object_vars($this)); } } 