<?php
namespace Moto\Database\Export; use Moto; use Illuminate; use PDO; class SqlExport { protected $_connection; protected $_tablePrefix; protected $_timeZone; protected static $_instance; public static function getInstance() { if (!static::$_instance) { static::$_instance = new static(); } return static::$_instance; } public function resolveTableName($name) { if (!is_string($name)) { return null; } return $this->getTablePrefix() . $name; } public function getTableStructure($name) { $tableName = $this->resolveTableName($name); if (!$tableName) { return false; } $query = 'SHOW CREATE TABLE ' . Moto\Database\Util::backQuoteName($tableName); $connection = $this->getConnection(); $result = $connection->selectOne($query); if (!$result) { return null; } $result = (array) $result; $result = array_values($result); if (count($result) < 2) { return null; } $response = str_replace(["\r\n", "\r"], "\n", $result[1]); $response = trim($response); if ($name !== $tableName) { $response = preg_replace('/^(CREATE TABLE (IF NOT EXISTS )?`)([^`]+)/i', '$1' . $name, $response); } $response = preg_replace('/([\s]?AUTO_INCREMENT[\s]?\=[\s]?[0-9]+[\s]?)/i', ' ', $response); $response .= ";\n"; return $response; } public function getTableMeta($name) { $tableName = $this->resolveTableName($name); if (!$tableName) { return false; } $connection = $this->getConnection(); $meta = [ 'name' => $name, 'table' => $tableName, 'types' => [], 'columns' => [], ]; $pdo = $connection->getPdo(); $emulateAttribute = $pdo->getAttribute(PDO::ATTR_EMULATE_PREPARES); $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false); $query = 'SELECT * FROM ' . Moto\Database\Util::backQuoteName($tableName) . ' LIMIT 1'; $statement = $connection->getPdo()->prepare($query); $statement->execute(); for ($i = 0, $len = $statement->columnCount(); $i < $len; $i++) { $data = $statement->getColumnMeta($i); $data['native_type'] = strtoupper($data['native_type']); $data['flags'] = array_map('strtolower', $data['flags']); $data['sql_collation'] = null; $data['sql_type'] = null; $data['sql_default'] = null; $meta['columns'][$data['name']] = $data; } $statement->closeCursor(); $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, $emulateAttribute); $query = 'SHOW FULL COLUMNS FROM ' . Moto\Database\Util::backQuoteName($tableName); $result = $connection->select($query); if ($result) { foreach ($result as $data) { if (!array_key_exists($data->Field, $meta['columns'])) { continue; } $meta['columns'][$data->Field]['sql_collation'] = strtolower($data->Collation); $meta['columns'][$data->Field]['sql_type'] = strtolower($data->Type); $meta['types'][$data->Field] = strtolower($data->Type); $meta['columns'][$data->Field]['sql_default'] = $data->Default; } } return $meta; } protected function generateInsertHeader($name, $columns, $options = []) { $header = 'INSERT'; if (Moto\Util::getValue($options, 'sqlDelayed')) { $header .= ' DELAYED'; } if (Moto\Util::getValue($options, 'sqlIgnore')) { $header .= ' IGNORE'; } $header .= ' INTO ' . Moto\Database\Util::backQuoteName($name) . ' (' . implode(', ', Moto\Database\Util::backQuoteName($columns)) . ') VALUES '; return $header; } public function getTableContent($name, $options = []) { $tableName = $this->resolveTableName($name); if (!$tableName) { return false; } $tableMeta = $this->getTableMeta($name); $this->lockTimeZone(); $connection = $this->getConnection(); $pdo = $connection->getPdo(); $query = 'SELECT * FROM ' . Moto\Database\Util::backQuoteName($tableName); $statement = $pdo->prepare($query); $statement->setFetchMode(PDO::FETCH_ASSOC); $statement->execute(); $maxQueryLines = (int) Moto\Util::getValue($options, 'maxLines', 1000); $maxQuerySize = (int) Moto\Util::getValue($options, 'maxSize', 1048576); $proxy = (object) [ 'code' => '', ]; $processor = Moto\Util::getValue($options, 'processor'); if (!is_callable($processor)) { $processor = function ($header, $code, $meta) use ($proxy) { if (is_array($code)) { $proxy->code .= $header . "\n" . implode(",\n", $code) . ";\n"; } else { $proxy->code .= $header . "\n" . $code . ";\n"; } }; } $queries = []; $queryLines = 0; $queriesSize = 0; $queriesPart = 1; $header = null; foreach ($statement as $record) { if (!$header) { $header = $this->generateInsertHeader($name, array_keys($record), $options); } $values = Moto\Database\Export\Util::sanitizeValues($record, $tableMeta['types'], $pdo); $insert = '(' . implode(', ', $values) . ')'; $querySize = strlen($insert); if (($maxQueryLines > 0 && $queryLines === $maxQueryLines) || ($maxQuerySize > 0 && $queriesSize + $querySize >= $maxQuerySize)) { $processor($header, $queries, [ 'table' => $name, 'queryLines' => $queryLines, 'querySize' => $queriesSize, 'queriesPart' => $queriesPart, ]); $queriesPart++; $queries = []; $queryLines = 0; $queriesSize = 0; } $queries[] = $insert; $queriesSize += $querySize; $queryLines++; } $statement->closeCursor(); $this->unlockTimeZone(); if (count($queries) > 0) { $processor($header, $queries, [ 'table' => $name, 'queryLines' => $queryLines, 'querySize' => $queriesSize, 'queriesPart' => $queriesPart, ]); } return $proxy->code; } protected function lockTimeZone() { if ($this->_timeZone === false) { return; } $connection = $this->getConnection(); $result = $connection->selectOne('SELECT @@session.time_zone AS \'time_zone\''); if ($result) { $this->_timeZone = $result->time_zone; } if (!$connection->statement('SET time_zone = "+00:00"')) { $this->_timeZone = false; } } protected function unlockTimeZone() { if (!$this->_timeZone) { return; } $this->getConnection()->statement('SET time_zone = "' . $this->_timeZone . '"'); $this->_timeZone = null; } protected function getConnection() { if ($this->_connection) { return $this->_connection; } $this->_connection = Moto\Database\Provider::getConnection('export'); $this->_connection->getPdo()->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY, false); return $this->_connection; } public function setConnection($connection) { if ($connection instanceof Illuminate\Database\Connection) { $this->_connection = $connection; return true; } return false; } public function getTablePrefix() { if ($this->_tablePrefix === null) { $this->_tablePrefix = Moto\Database\Provider::getTablePrefix(); } return $this->_tablePrefix; } public function setTablePrefix($prefix) { if (!is_string($prefix)) { return false; } $this->_tablePrefix = $prefix; return true; } } 