<?php
namespace Moto\Database\Models; use Moto; use Illuminate; class Font extends Moto\Database\BaseModel { const CREATED_AT = 'created'; const UPDATED_AT = 'modified'; const PROVIDER__CUSTOM = 'custom'; protected $table = 'fonts'; protected $morphClass = '@Font'; protected $_legacyModel = Moto\Application\Fonts\FontModel::class; protected $fillable = [ 'name', 'family', 'category', 'variants', 'subsets', 'properties', 'version', 'last_modified', 'active', 'is_protected', 'active_variants', 'active_subsets', 'provider', ]; protected $casts = [ 'name' => 'string', 'family' => 'string', 'category' => 'string', 'variants' => 'array', 'subsets' => 'array', 'properties' => 'array', 'version' => 'string', 'last_modified' => 'string', 'active' => 'boolean', 'is_protected' => 'boolean', 'active_variants' => 'array', 'active_subsets' => 'array', 'provider' => 'string', ]; protected $attributes = [ 'name' => '', 'family' => '', 'category' => '', 'variants' => '[]', 'subsets' => '[]', 'properties' => '[]', 'version' => '', 'last_modified' => '', 'active' => true, 'is_protected' => false, 'active_variants' => '[]', 'active_subsets' => '[]', 'provider' => '', ]; protected $visible = [ ]; protected $hidden = [ ]; protected $dates = [ ]; protected $appends = [ ]; protected $_customVariants = []; public static function boot() { parent::boot(); static::saving(function ($model) { $model->syncCustomVariants(); }); static::deleted(function ($model) { $collection = $model->getCustomVariants(); if (!$collection) { return; } foreach ($collection as $variant) { try { $variant->delete(); } catch (\Exception $e) { Moto\System\Log::warning('Error on delete custom variant', [ 'exception' => [ 'code' => $e->getCode(), 'message' => $e->getMessage(), ], 'variant' => $variant->toArray(), ]); } } }); } public function getPropertiesAttribute($value) { if (is_string($value)) { $value = $this->fromJson($value); } if ($value === null) { $value = []; } return $value; } public function setPropertiesAttribute($value) { $key = 'properties'; if (!is_string($value)) { $value = $this->castAttributeAsJson($key, $value); } $this->attributes[$key] = $value; return $this; } public function isExistsVariant($name) { return in_array($name, (array) $this->variants, true); } public function addVariant($variant) { if ($variant instanceof Moto\Application\Fonts\CustomVariantModel) { return $this->addCustomVariant($variant); } if (!is_string($variant)) { return false; } $variant = trim($variant); if ($variant === '') { return false; } if ($this->isExistsVariant($variant)) { return true; } $variants = (array) $this->variants; $variants[] = $variant; $this->variants = $variants; return true; } public function addCustomVariant(Moto\Application\Fonts\CustomVariantModel $variant) { if ($variant->getFontModel() !== $this) { return false; } if (!$this->addVariant($variant->name)) { return false; } $this->_customVariants[$variant->name] = $variant; return true; } public function removeVariant($name) { if (!is_string($name)) { return false; } $name = trim($name); if ($name === '') { return false; } if (!$this->isExistsVariant($name)) { return true; } $this->deactivateVariant($name); $variants = (array) $this->variants; $index = array_search($name, $variants, true); if (!is_int($index)) { return false; } array_splice($variants, $index, 1); $this->variants = $variants; return true; } public function isActiveVariant($name) { return in_array($name, (array) $this->active_variants, true); } public function activateVariant($name) { if (!$this->isExistsVariant($name)) { return false; } if ($this->isActiveVariant($name)) { return true; } $variants = (array) $this->active_variants; $variants[] = $name; $this->active_variants = $variants; return true; } public function deactivateVariant($name) { if (!$this->isActiveVariant($name)) { return true; } $variants = (array) $this->active_variants; $index = array_search($name, $variants, true); if (!is_int($index)) { return false; } array_splice($variants, $index, 1); $this->active_variants = $variants; return true; } public function getCustomVariants() { if ($this->provider !== static::PROVIDER__CUSTOM) { return null; } $collection = new Moto\System\BaseCollection(); $variants = (array) $this->variants; foreach ($variants as $name) { $variant = $this->getCustomVariant($name); if (!$variant) { continue; } $collection->push($variant); } return $collection; } public function getCustomVariant($name) { if ($this->provider !== static::PROVIDER__CUSTOM) { return null; } $name = trim((string) $name); if (!$this->isExistsVariant($name)) { return null; } if (array_key_exists($name, $this->_customVariants)) { return $this->_customVariants[$name]; } $variant = $this->firstOrNewCustomVariant($name); $this->_customVariants[$name] = $variant; return $variant; } public function firstOrNewCustomVariant($name) { if ($this->provider !== static::PROVIDER__CUSTOM) { return null; } $name = trim((string) $name); if (array_key_exists($name, $this->_customVariants)) { return $this->_customVariants[$name]; } $attributes = Moto\Util::getValue($this->properties, 'custom_variants.' . $name); if (!$attributes) { $attributes = [ 'name' => $name, ]; } $variant = new Moto\Application\Fonts\CustomVariantModel($attributes); $variant->setFontModel($this); return $variant; } public function syncCustomVariants() { $properties = $this->properties; $variants = []; foreach ($this->variants as $name) { $variant = $this->getCustomVariant($name); if (!$variant || empty($variant->name)) { continue; } $variants[$variant->name] = $variant->toArray(); } $properties['custom_variants'] = $variants; $this->properties = $properties; return true; } public function generateCssContent() { $result = ''; $activeVariants = $this->active_variants; if (empty($activeVariants)) { return null; } foreach ($activeVariants as $name) { $variant = $this->getCustomVariant($name); if (!$variant) { continue; } $css = $variant->generateCssContent(); if (!is_string($css) || $css === '') { continue; } $result .= $css . "\n"; } return $result; } } 