<?php
namespace Moto\Database\Models; use Moto; use Illuminate; class Preset extends Moto\Database\BaseModel { const CREATED_AT = 'created'; const UPDATED_AT = 'modified'; protected $table = 'presets'; protected $morphClass = '@Preset'; protected $_legacyModel = Moto\Application\Presets\PresetModel::class; protected $fillable = [ 'name', 'widget_name', 'class_name', 'provider', 'is_system', 'is_responsive', 'properties', 'template', ]; protected $casts = [ 'name' => 'string', 'widget_name' => 'string', 'class_name' => 'string', 'provider' => 'string', 'is_system' => 'boolean', 'is_responsive' => 'boolean', 'properties' => 'array', 'template' => 'string', ]; protected $attributes = [ 'name' => '', 'widget_name' => '', 'class_name' => '', 'provider' => 'default', 'is_system' => false, 'is_responsive' => false, 'properties' => '{}', 'template' => 'default', ]; protected $visible = [ ]; protected $hidden = [ ]; protected $dates = [ ]; public function setNameAttribute($value) { if (!$this->is_system || static::$unguarded) { $this->attributes['name'] = $value; } return $this; } public function setWidgetNameAttribute($value) { if (empty($this->attributes['widget_name']) || static::$unguarded) { $this->attributes['widget_name'] = $value; } return $this; } public function setClassNameAttribute($value) { if (empty($this->attributes['class_name']) || static::$unguarded) { $this->attributes['class_name'] = $value; } return $this; } public function setPropertiesAttribute($value) { $key = 'properties'; if (!is_string($value)) { $value = $this->castAttributeAsJson($key, $value); } $this->attributes[$key] = $value; return $this; } public function getTemplatePath() { if (!empty($this->template) && $this->template[0] === '@') { return $this->template; } return '@websiteWidgets/' . $this->widget_name . '/templates/' . ($this->template ? $this->template : $this->provider) . '.twig.css'; } } 