<?php
 namespace Moto\Database\Models; use Moto; use Illuminate; class User extends Moto\Database\BaseModel { const CREATED_AT = 'created'; const UPDATED_AT = 'modified'; const DEFAULT_PREFERENCES_VALUE = [ '__version' => 1, 'ui' => [ 'theme' => 'dark', 'editor_quick_tools' => 'all', ], ]; protected $table = 'users'; protected $morphClass = '@User'; protected $_legacyModel = Moto\Application\Users\UserModel::class; protected $fillable = [ 'email', 'name', 'role_id', 'language_id', 'enabled', ]; protected $casts = [ 'id' => 'int', 'email' => 'string', 'name' => 'string', 'role_id' => 'int', 'language_id' => 'int', 'enabled' => 'boolean', 'preferences' => 'array', ]; protected $attributes = [ 'email' => '', 'name' => '', 'role_id' => 1, 'language_id' => 1, 'enabled' => true, ]; protected $visible = [ ]; protected $hidden = [ 'login', 'password', 'salt', 'del', ]; protected $dates = [ ]; protected $appends = [ 'role_name', 'language_name', 'language_code', 'language_locale', ]; public static function boot() { parent::boot(); static::creating(function ($model) { if (empty($model->preferences)) { $model->preferences = static::DEFAULT_PREFERENCES_VALUE; } }); static::retrieved(function ($model) { $model->migratePreferences(); }); } public function role() { return $this->belongsTo(Moto\Database\Models\Role::class, 'role_id', 'id'); } public function language() { return $this->belongsTo(Moto\Database\Models\Language::class, 'language_id', 'id'); } protected function migratePreferences() { $preferences = $this->preferences; $version = (int) Moto\Util::getValue($preferences, '__version', 0); if ($version >= static::DEFAULT_PREFERENCES_VALUE['__version']) { return true; } foreach (static::DEFAULT_PREFERENCES_VALUE as $namespace => $value) { if (!array_key_exists($namespace, $preferences)) { $preferences[$namespace] = $value; continue; } if (is_array($value)) { $preferences[$namespace] = array_merge($value, $preferences[$namespace]); } } $preferences['__version'] = static::DEFAULT_PREFERENCES_VALUE['__version']; $this->preferences = $preferences; return true; } public function setPreference($name, $value = null) { if (is_array($name)) { foreach ($name as $key => $value) { $this->setPreference($key, $value); } return true; } if (!is_string($name)) { throw new \InvalidArgumentException('Name is not a string'); } $name = trim($name); if ($name === '') { throw new \InvalidArgumentException('Name is empty'); } if (strpos($name, '.') === false && !is_array($value)) { throw new \InvalidArgumentException('Value must be array for first level'); } $data = $this->preferences; Illuminate\Support\Arr::set($data, $name, $value); $this->preferences = $data; return true; } public function unsetPreference($name) { if (is_array($name)) { foreach ($name as $key) { $this->unsetPreference($key); } return true; } if (!is_string($name)) { throw new \InvalidArgumentException('Name is not a string'); } $name = trim($name); if ($name === '') { throw new \InvalidArgumentException('Name is empty'); } $data = $this->preferences; Illuminate\Support\Arr::forget($data, $name); $this->preferences = $data; return true; } public function getPreference($name, $default = null) { if (!is_string($name)) { throw new \InvalidArgumentException('Name is not a string'); } $name = trim($name); if ($name === '') { throw new \InvalidArgumentException('Name is empty'); } return Illuminate\Support\Arr::get($this->preferences, $name, $default); } public function updatePreference($name, $value) { if (!is_string($name)) { throw new \InvalidArgumentException('Name is not a string'); } $name = trim($name); if ($name === '') { throw new \InvalidArgumentException('Name is empty'); } if (!is_array($value)) { throw new \InvalidArgumentException('Value is not an array'); } return $this->updatePreferences([$name => $value]); } public function updatePreferences($preferences) { if (!is_array($preferences)) { throw new \InvalidArgumentException('Preferences is not an array'); } $data = $this->preferences; foreach ($preferences as $name => $value) { if (!is_string($name)) { throw new \InvalidArgumentException('Name is not a string'); } if (!is_array($value)) { throw new \InvalidArgumentException('Value is not an array'); } if (array_key_exists($name, $data)) { $data[$name] = array_merge($data[$name], $value); } else { $data[$name] = $value; } } $this->preferences = $data; return true; } public function getRoleNameAttribute($value = null) { if ($this->role) { return $this->role->name; } return null; } public function getLanguageNameAttribute($value = null) { if ($this->language) { return $this->language->name; } return null; } public function getLanguageCodeAttribute($value = null) { if ($this->language) { return $this->language->code; } return null; } public function getLanguageLocaleAttribute($value = null) { if ($this->language) { return $this->language->locale; } return null; } public function isValidPassword($password) { return Moto\Authentication\Security::verify($password, $this->password); } public function setPassword($openPassword) { $this->password = Moto\Authentication\Security::hashPassword($openPassword, Moto\Authentication\Security::generateSalt()); } } 