<?php
namespace Moto\Database; use Moto; use Illuminate; class Util { public static function listsOrPluck($collection, $value, $key = null) { if (!($collection instanceof Illuminate\Support\Collection)) { return null; } $data = array(); if (method_exists($collection, 'lists')) { $data = $collection->lists($value, $key); } elseif (method_exists($collection, 'pluck')) { $data = $collection->pluck($value, $key); } if ($data instanceof Illuminate\Support\Collection) { $data = $data->toArray(); } return $data; } public static function isSupportsCharset($charset = 'utf8') { if (!preg_match('/^[a-z0-9\-\_]+$/i', $charset)) { throw new \Exception('CHARSET_INVALID'); } $db = Moto\Database\Provider::getDatabaseCapsule(); $list = $db->getConnection()->select("SHOW CHARACTER SET WHERE CHARSET = '$charset'"); return (count($list) > 0); } public static function convertTableCharsetToDefault($tableName) { if (!preg_match('/^[a-z\-\_0-9]+$/i', $tableName)) { return false; } $db = Moto\Database\Provider::getDatabaseCapsule(); $prefix = Moto\Database\Provider::getTablePrefix(); $sql = 'ALTER TABLE `' . $prefix . $tableName . '` CONVERT TO CHARACTER SET ' . Moto\Database\Provider::DEFAULT_CHARSET . ' COLLATE ' . Moto\Database\Provider::DEFAULT_CHARSET . Moto\Database\Provider::DEFAULT_COLLATE_POSTFIX . ';'; $db->getConnection()->statement($sql); return true; } public static function tableHasIndex($tableName, $indexName) { $tableName = trim((string) $tableName); $indexName = trim((string) $indexName); if ($tableName === '' || $indexName === '') { throw new \Exception('Bad arguments'); } if (!preg_match('/^[a-z\-\_0-9]+$/i', $tableName)) { throw new \Exception('Invalid table name'); } if (!preg_match('/^[a-z\-\_0-9]+$/i', $indexName)) { throw new \Exception('Invalid index name'); } $db = Moto\Database\Provider::getDatabaseCapsule(); $prefix = Moto\Database\Provider::getTablePrefix(); $sql = "SHOW INDEX FROM `{$prefix}{$tableName}` WHERE Key_name = '{$indexName}';"; $list = $db->getConnection()->select($sql); return (count($list) > 0); } public static function backQuoteName($name) { if (is_array($name)) { foreach($name as $index => $value) { $name[$index] = static::backQuoteName($value); } return $name; } if (!is_string($name)) { return $name; } if ($name !== '*' && $name !== '') { return '`' . str_replace('`', '``', $name) . '`'; } return $name; } } 