<?php
namespace Moto\Filter; use Moto; use Closure; class UniqueFileName extends Moto\Filter\AbstractFilter { protected $_options = [ 'baseDir' => '@userUploads', 'prefix' => '', 'suffix' => '_', 'maxIteration' => 10, 'uniqueGenerator' => null, 'tryTimeStamp' => '', ]; protected static $_defaultUniqueGenerator; public function setBaseDir($value) { if (!is_string($value)) { throw new \InvalidArgumentException('Option "baseDir" : value is not a string'); } $value = trim($value); if ($value === '') { throw new \InvalidArgumentException('Option "baseDir" : value is empty'); } $value = rtrim($value, '/'); $path = Moto\System::getAbsolutePath($value); if ($path === '') { throw new \InvalidArgumentException('Option "baseDir" : resolved absolute path is empty'); } if (!is_dir($path)) { throw new \InvalidArgumentException('Option "baseDir" : path is not directory'); } $this->_options['baseDir'] = $value; return $this; } public function setPrefix($value) { if (!is_string($value)) { throw new \InvalidArgumentException('Option "prefix" : value is not a string'); } if ($value !== '' && !preg_match('/^[a-z0-9\-\_\/]+$/', $value)) { throw new \InvalidArgumentException('Option "prefix" : invalid value "' . $value . '"'); } $this->_options['prefix'] = $value; return $this; } public function setSuffix($value) { if (!is_string($value)) { throw new \InvalidArgumentException('Option "suffix" : value is not a string'); } if ($value !== '' && !preg_match('/^[a-z0-9\-\_]+$/', $value)) { throw new \InvalidArgumentException('Option "suffix" : invalid value "' . $value . '"'); } $this->_options['suffix'] = $value; return $this; } public function setMaxIteration($value) { if (!is_int($value)) { throw new \InvalidArgumentException('Option "maxIteration" : value is not a int'); } if ($value < 1) { throw new \InvalidArgumentException('Option "maxIteration" : value must be great 0'); } $this->_options['maxIteration'] = $value; return $this; } public function setUniqueGenerator($value = null) { if ($value === null || $value instanceof Closure) { $this->_options['uniqueGenerator'] = $value; return $this; } throw new \InvalidArgumentException('Option "uniqueGenerator" : invalid value'); } public function setTryTimeStamp($value) { if (!is_string($value)) { throw new \InvalidArgumentException('Option "tryTimeStamp" : value is not a string'); } if ($value !== '' && !preg_match('/^[a-z0-9\-\_]+$/i', $value)) { throw new \InvalidArgumentException('Option "tryTimeStamp" : invalid value "' . $value . '"'); } $this->_options['tryTimeStamp'] = $value; return $this; } public function getBaseDir() { return $this->getOption('baseDir'); } public function filter($value) { if (!is_string($value)) { return null; } $value = trim($value); if ($value === '') { return null; } $value = Moto\Util::sanitizePath($value); $valueDir = Moto\Util::sanitizePath(dirname($value) . '/'); if ($valueDir === './') { $valueDir = ''; } $fileName = basename($value); if ($value[0] === '@') { $baseDir = $valueDir; } else { if ($value[0] === '.' || Moto\Util::isResolvablePath($value)) { $baseDir = $this->getBaseDir() . '/' . $valueDir; } else { $baseDir = $valueDir; } } if ($baseDir[0] === '@') { $absoluteDirPath = Moto\System::getAbsolutePath($baseDir); } else { $absoluteDirPath = $baseDir; } if ($absoluteDirPath === '') { return null; } if (!file_exists($absoluteDirPath . '/' . $fileName)) { return $value; } $pathInfo = pathinfo($value); $prefix = $this->getOption('prefix'); $suffix = $this->getOption('suffix'); $timeStamp = $this->getOption('tryTimeStamp'); if ($timeStamp !== '') { $newFileName = $prefix . $pathInfo['filename'] . $suffix . date($timeStamp) . '.' . $pathInfo['extension']; if (!file_exists($absoluteDirPath . '/' . $newFileName)) { return $valueDir . $newFileName; } } $maxIteration = $this->getOption('maxIteration'); $previousUid = null; $newValue = null; for ($i = 0; $i < $maxIteration + 1; $i++) { $uid = $this->generateUniqueValue($i + 1, $value, $previousUid); if ($uid === '') { throw new \RuntimeException('Unique generator return invalid value'); } if ($uid === $previousUid) { throw new \RuntimeException('Unique generator return previous value'); } $newFileName = $prefix . $pathInfo['filename'] . $suffix . $uid . '.' . $pathInfo['extension']; if (!file_exists($absoluteDirPath . '/' . $newFileName)) { $newValue = $valueDir . $newFileName; break; } if ($i >= $maxIteration) { throw new \RuntimeException('Reached max iteration limit'); } $previousUid = $uid; } return $newValue; } protected function generateUniqueValue($trying, $value, $previousUid) { $generator = $this->getUniqueGenerator(); $uid = $generator($trying, $value, $previousUid); $uid = (string) $uid; $uid = trim($uid); return $uid; } protected function getUniqueGenerator() { $generator = $this->getOption('uniqueGenerator'); if (!$generator) { $generator = $this->getDefaultUniqueGenerator(); } return $generator; } protected function getDefaultUniqueGenerator() { if (!static::$_defaultUniqueGenerator) { static::$_defaultUniqueGenerator = function () { return Moto\Util::getUniqueId(); }; } return static::$_defaultUniqueGenerator; } } 