<?php
 namespace Moto\Helpers; use Moto; use Illuminate; use Exception; class PageDuplicator { use Moto\System\Traits\OptionsTrait; protected $_options = [ 'uniqueStartIndex' => 2, 'except' => [ ], 'defaultAttributes' => [ 'status' => 'draft', ], 'syncRelations' => true, 'relations' => [ 'tags', ], ]; protected $_sourcePage; protected $_clonePage; protected $_pageTable; protected function getPageTable() { if ($this->_pageTable === null) { $table = new Moto\Application\Pages\PagesTable(); $table->useResultAsModel(true); $this->_pageTable = $table; } return $this->_pageTable; } public function setSourcePage($page) { $this->_sourcePage = $page; $this->_clonePage = null; return $this; } public function getSourcePage() { return $this->_sourcePage; } protected function requirePage() { $page = $this->getSourcePage(); if (!$page) { throw new Exception('Page is require'); } return $page; } public function setExceptOption($value) { if ($value === null || is_array($value)) { return $this->setOptionRawValue('except', $value); } return false; } public function setDefaultAttributesOption($value) { if (!is_array($value)) { return false; } return $this->setOptionRawValue('defaultAttributes', $value); } public function setRelationsOption($relations) { if (is_array($relations)) { return false; } $relations = array_unique($relations); foreach ($relations as $relation) { if (!is_string($relation) || $relation === '') { return false; } } $relations = array_values($relations); return $this->setOptionRawValue('relations', $relations); } protected function getClonePage() { if ($this->_clonePage) { return $this->_clonePage; } $page = $this->requirePage(); $relations = $page->getRelations(); $page->setRelations([]); $except = $this->getOption('except'); $clone = $page->replicate($except); $page->setRelations($relations); $clone->fill($this->getOption('defaultAttributes')); $this->_clonePage = $clone; return $clone; } public function unsetClone() { $this->_clonePage = null; } public function fillAttributes(array $attributes) { $this->getClonePage()->fill($attributes); return $this; } public function setAttributes(array $attributes) { $clone = $this->getClonePage(); foreach ($attributes as $key => $value) { $clone->setAttribute($key, $value); } return $this; } public function setAttribute($key, $value) { $this->getClonePage()->setAttribute($key, $value); return $this; } public function syncRelations() { $relations = $this->getOption('relations'); if (empty($relations)) { return $this; } $page = $this->requirePage(); $clone = $this->getClonePage(); if (!$clone->exists) { throw new Exception('Sync relations available only for saved clone'); } foreach ($relations as $relation) { if (!$this->syncRelation($page, $clone, $relation)) { throw new Exception('Cant sync relation "' . $relation . '"'); } } return $this; } protected function syncRelation($page, $clone, $name) { $value = $page->loadMissing($name)->getAttribute($name); if (!$value) { return true; } if (!($value instanceof Illuminate\Support\Collection)) { throw new Exception('RELATION_VALUE_NOT_SUPPORTED'); } if ($value->isEmpty()) { return true; } $relation = $clone->{$name}(); if (!($relation instanceof Illuminate\Database\Eloquent\Relations\BelongsToMany)) { throw new Exception('RELATION_TYPE_NOT_SUPPORTED'); } $relation->sync($value); return true; } public function createClone() { $clone = $this->getClonePage(); $connection = Moto\Database\Provider::getConnection(); $connection->beginTransaction(); try { $temp = $this->duplicatePageContent($clone->content); $styles = $temp->styles; $clone->content = $temp->content; $clone->save(); $closureTable = $this->getPageTable()->getClosureTable(); $closureTable->insertNode($clone->id, $clone->parent_id); if (count($styles) > 0) { $styleTable = new Moto\Application\Styles\StylesTable(); $styleTable->useResultAsModel(true); foreach ($styles as $style) { $styleTable->save($style); } Moto\System\Style::rebuildAll(); } if ($this->getOption('syncRelations')) { $this->syncRelations(); } $connection->commit(); } catch (\Exception $e) { $connection->rollBack(); throw $e; } return $clone; } protected function getUniqueizeValidationQuery() { $clone = $this->getClonePage(); $query = Moto\Database\Page::query(); $query->where('parent_id', '=', $clone->parent_id); $query->where('content_locale_code', '=', $clone->content_locale_code); return $query; } public function uniqueizeAttributes($keys = []) { $page = $this->requirePage(); $clone = $this->getClonePage(); $attributes = []; $query = $this->getUniqueizeValidationQuery(); if (in_array('url', $keys)) { $filter = new Moto\Filter\UniqueDatabaseValue([ 'query' => $query, 'column' => 'url', 'startIndex' => (int) $this->getOption('uniqueStartIndex', 2), ]); $attributes['url'] = $filter->filter($clone->url); $lastIndex = (int) $filter->getLastIndex(); if ($lastIndex > 0) { if (in_array('name', $keys) && ($page->name === $clone->name)) { $attributes['name'] = $page->name . ' ' . $lastIndex; } if (in_array('title', $keys) && ($page->title === $clone->title)) { $attributes['title'] = $page->title . ' ' . $lastIndex; } } } $this->setAttributes($attributes); return $this; } public function duplicatePageContent($content) { if (!is_string($content)) { return false; } $styles = new Illuminate\Support\Collection(); $containers = Moto\Application\Content\Util::findContainers($content); if (!empty($containers)) { $styleTable = new Moto\Application\Styles\StylesTable(); $styleTable->useResultAsModel(true); foreach ($containers as $containerClassName) { $newClassName = 'moto-container_content_' . Moto\Util::getUniqueId(); $styleRecord = $styleTable->getByClassName($containerClassName); if ($styleRecord) { $newStyleRecord = $styleTable->duplicate($styleRecord); $newStyleRecord->name = $newClassName; $newStyleRecord->class_name = $newClassName; $styles->push($newStyleRecord); } $content = str_replace($containerClassName, $newClassName, $content); } } $result = [ 'content' => $content, 'styles' => $styles, ]; return (object) $result; } } 